/*
 * Decompiled with CFR 0.152.
 */
package com.github.adminfaces.template.util;

import com.github.adminfaces.template.util.Assert;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;

public class AdminUtils {
    public static void redirect(String url, Object ... paramValues) {
        AdminUtils.redirect(FacesContext.getCurrentInstance(), url, paramValues);
    }

    private static void redirect(FacesContext context, String url, Object ... paramValues) {
        ExternalContext externalContext = context.getExternalContext();
        externalContext.getFlash().setRedirect(true);
        try {
            externalContext.redirect(AdminUtils.prepareRedirectURL(AdminUtils.getRequest(context), url, paramValues));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not redirect to url: " + url, e);
        }
    }

    public static HttpServletRequest getRequest(FacesContext context) {
        return (HttpServletRequest)context.getExternalContext().getRequest();
    }

    private static String prepareRedirectURL(HttpServletRequest request, String url, Object ... paramValues) {
        String redirectURL = url;
        if (!Assert.startsWithOneOf(url, "http://", "https://", "/")) {
            redirectURL = request.getContextPath() + "/" + url;
        }
        if (!Assert.has(paramValues)) {
            return redirectURL;
        }
        Object[] encodedParams = new Object[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            Object paramValue = paramValues[i];
            encodedParams[i] = paramValue instanceof String ? AdminUtils.encodeURL((String)paramValue) : paramValue;
        }
        return String.format(redirectURL, encodedParams);
    }

    public static String encodeURL(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLEncoder.encode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("UTF-8 is apparently not supported on this platform.", e);
        }
    }
}

