package ar.com.sdd.agrofyapi.io;

import ar.com.sdd.agrofyapi.model.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class WebhookBindRequest implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("object")
    private String object;

    @JsonProperty("created")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone = "GMT-03:00")
    private Date created;

    @JsonProperty("data")
    private Data data;

    @JsonProperty("type")
    private String type;

    @JsonProperty("redeliveries")
    private Integer redeliveries;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getObject() {
        return object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public Date getCreated() {
        return created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Data getData() {
        return data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getRedeliveries() {
        return redeliveries;
    }

    public void setRedeliveries(Integer redeliveries) {
        this.redeliveries = redeliveries;
    }

    @Override
    public String toString() {
        return "WebhookBindRequest [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((object != null) ? "object='" + object + "', " : "") +
                ((created != null) ? "created=" + created + ", " : "") +
                ((data != null) ? "data=" + data + ", " : "") +
                ((type != null) ? "type='" + type + "', " : "") +
                ((redeliveries != null) ? "redeliveries=" + redeliveries + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        WebhookBindRequest that = (WebhookBindRequest) o;
        return Objects.equals(id, that.id) && Objects.equals(object, that.object) && Objects.equals(created, that.created) && Objects.equals(data, that.data) && Objects.equals(type, that.type) && Objects.equals(redeliveries, that.redeliveries);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, object, created, data, type, redeliveries);
    }
}
