package ar.com.sdd.agrofyapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CounterParty implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("name")
    private String name;

    @JsonProperty("id_type")
    private String id_type;

    @JsonProperty("bank_routing")
    private BankRouting bank_routing;

    @JsonProperty("account_routing")
    private AccountRouting account_routing;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId_type() {
        return id_type;
    }

    public void setId_type(String id_type) {
        this.id_type = id_type;
    }

    public BankRouting getBank_routing() {
        return bank_routing;
    }

    public void setBank_routing(BankRouting bank_routing) {
        this.bank_routing = bank_routing;
    }

    public AccountRouting getAccount_routing() {
        return account_routing;
    }

    public void setAccount_routing(AccountRouting account_routing) {
        this.account_routing = account_routing;
    }

    @Override
    public String toString() {
        return "CounterParty [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((name != null) ? "name='" + name + "', " : "") +
                ((id_type != null) ? "id_type='" + id_type + "', " : "") +
                ((bank_routing != null) ? "bank_routing=" + bank_routing + ", " : "") +
                ((account_routing != null) ? "account_routing=" + account_routing + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CounterParty that = (CounterParty) o;
        return Objects.equals(id, that.id) && Objects.equals(name, that.name) && Objects.equals(id_type, that.id_type) && Objects.equals(bank_routing, that.bank_routing) && Objects.equals(account_routing, that.account_routing);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, id_type, bank_routing, account_routing);
    }
}
