package ar.com.sdd.agrofyapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class InvolvedTransactionsPaymentIntent implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("number")
    private Integer number;

    @JsonProperty("created")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timezone = "GMT-03:00")
    private Date created;

    @JsonProperty("businessDate")
    private Integer businessDate;

    @JsonProperty("state")
    private Integer state;

    @JsonProperty("amount")
    private BigDecimal amount;

    @JsonProperty("amountSigned")
    private BigDecimal amountSigned;

    @JsonProperty("transactionType")
    private String transactionType;

    @JsonProperty("comments")
    private String comments;

    @JsonProperty("complementaryTransactions")
    private List<String> complementaryTransactions;

    @JsonProperty("nestedTransactions")
    private List<String> nestedTransactions;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public Date getCreated() {
        return created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Integer getBusinessDate() {
        return businessDate;
    }

    public void setBusinessDate(Integer businessDate) {
        this.businessDate = businessDate;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getAmountSigned() {
        return amountSigned;
    }

    public void setAmountSigned(BigDecimal amountSigned) {
        this.amountSigned = amountSigned;
    }

    public String getTransactionType() {
        return transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public List<String> getComplementaryTransactions() {
        return complementaryTransactions;
    }

    public void setComplementaryTransactions(List<String> complementaryTransactions) {
        this.complementaryTransactions = complementaryTransactions;
    }

    public List<String> getNestedTransactions() {
        return nestedTransactions;
    }

    public void setNestedTransactions(List<String> nestedTransactions) {
        this.nestedTransactions = nestedTransactions;
    }

    @Override
    public String toString() {
        return "InvolvedTransactionsPaymentIntent [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((number != null) ? "number=" + number + ", " : "") +
                ((created != null) ? "created=" + created + ", " : "") +
                ((businessDate != null) ? "businessDate=" + businessDate + ", " : "") +
                ((state != null) ? "state=" + state + ", " : "") +
                ((amount != null) ? "amount=" + amount + ", " : "") +
                ((amountSigned != null) ? "amountSigned=" + amountSigned + ", " : "") +
                ((transactionType != null) ? "transactionType='" + transactionType + "', " : "") +
                ((comments != null) ? "comments='" + comments + "', " : "") +
                ((complementaryTransactions != null) ? "complementaryTransactions=" + Arrays.toString(complementaryTransactions.toArray()) + ", " : "") +
                ((nestedTransactions != null) ? "nestedTransactions=" + Arrays.toString(nestedTransactions.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        InvolvedTransactionsPaymentIntent that = (InvolvedTransactionsPaymentIntent) o;
        return Objects.equals(id, that.id) && Objects.equals(number, that.number) && Objects.equals(created, that.created) && Objects.equals(businessDate, that.businessDate) && Objects.equals(state, that.state) && Objects.equals(amount, that.amount) && Objects.equals(amountSigned, that.amountSigned) && Objects.equals(transactionType, that.transactionType) && Objects.equals(comments, that.comments) && Objects.equals(complementaryTransactions, that.complementaryTransactions) && Objects.equals(nestedTransactions, that.nestedTransactions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, number, created, businessDate, state, amount, amountSigned, transactionType, comments, complementaryTransactions, nestedTransactions);
    }
}
