/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.agrofyapi.core;

import ar.com.sdd.agrofyapi.core.AgrofyApiConnectorContext;
import ar.com.sdd.agrofyapi.io.CommonResponse;
import ar.com.sdd.agrofyapi.io.ErrorResponse;
import ar.com.sdd.agrofyapi.io.PaymentIntentRequest;
import ar.com.sdd.agrofyapi.io.WebhookBindRequest;
import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.core.RestSignSecurityManager;
import ar.com.sdd.commons.rest.model.TokenOAuth2;
import ar.com.sdd.commons.util.SimpleCache;
import ar.com.sdd.commons.util.SimpleCacheManager;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AgrofyApiConnector
implements RestSignSecurityManager {
    private static final Logger log = LogManager.getLogger(AgrofyApiConnector.class);
    private final RestConnector restConnector;
    private final String accessTokenBaseUrl;
    private final String applicationId;
    private final String deviceId;
    private final String userId;
    private final String userPassword;
    private final String accessModeType;

    public AgrofyApiConnector(AgrofyApiConnectorContext context) {
        this.accessTokenBaseUrl = context.getAccessTokenBaseUrl();
        this.applicationId = context.getApplicationId();
        this.deviceId = context.getDeviceId();
        this.userId = context.getUserId();
        this.userPassword = context.getUserPassword();
        this.accessModeType = context.getAccessModeType();
        log.trace("Creando AgrofyApiConnector para url [{}]", (Object)context.getAccessTokenBaseUrl());
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getAccessTokenBaseUrl());
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public CommonResponse createPaymentIntent(PaymentIntentRequest request) throws RestConnectorException {
        String path = "/payment/intent";
        log.debug("[createPaymentIntent] Request POST createPaymentIntent para el request [{}] path [{}]", (Object)request, (Object)"/payment/intent");
        return (CommonResponse)this.restConnector.genericPost((Object)request, CommonResponse.class, ErrorResponse.class, "/payment/intent", "application/json", "application/x-www-form-urlencoded");
    }

    public CommonResponse webhookBind(WebhookBindRequest request) throws RestConnectorException {
        String path = "/bind-api/webhooks";
        log.debug("[webhookBind] Request POST webhookBind para el request [{}] path [{}]", (Object)request, (Object)"/bind-api/webhooks");
        return (CommonResponse)this.restConnector.genericPost((Object)request, CommonResponse.class, ErrorResponse.class, "/bind-api/webhooks", "application/json", "application/x-www-form-urlencoded");
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder, String requestBody) throws RestConnectorException {
        throw new NotImplementedException("user addHeader con dos parametros");
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("applicationId", (Object)this.applicationId);
            builder.header("deviceId", (Object)this.deviceId);
            builder.header("Authorization", (Object)("Basic " + this.getAccessToken(false)));
            builder.header("accessToken", (Object)this.getAccessToken(false));
        }
        return builder;
    }

    public boolean retryOnUnauthorized() {
        try {
            this.getAccessToken(true);
            return true;
        }
        catch (RestConnectorException e) {
            log.error((Object)e);
            return false;
        }
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    public String getAccessToken(boolean force) throws RestConnectorException {
        SimpleCache cache = SimpleCacheManager.getInstance().getCache(AgrofyApiConnector.class.getName());
        String cacheKey = SimpleCacheManager.buildKey((Object[])new Object[]{"accessToken"});
        String accessToken = (String)cache.get(cacheKey);
        if (force || accessToken == null) {
            Form form = new Form();
            form.param("userId", this.userId);
            form.param("userPassword", this.userPassword);
            form.param("accessModeType", this.accessModeType);
            log.debug("[getAccessToken] Por recuperar token con userId [{}], userPassword [{}] y accessModeType [{}]", (Object)this.userId, (Object)this.userPassword, (Object)this.accessModeType);
            RestConnector connector = new RestConnector(new RestConnectorEnvironment(this.accessTokenBaseUrl), null);
            TokenOAuth2 tokenOAuth2Response = (TokenOAuth2)connector.genericPost((Object)form, TokenOAuth2.class, "/login", "application/json", "application/x-www-form-urlencoded");
            log.debug("[getAccessToken] Token recuperado [{}]. Expira en [{}]segs. Lo agrego al a cache", (Object)tokenOAuth2Response, (Object)tokenOAuth2Response.getExpiresIn());
            accessToken = tokenOAuth2Response.getAccessToken();
            cache.put(cacheKey, (Object)accessToken, Integer.valueOf(tokenOAuth2Response.getExpiresIn() - 10));
        }
        return accessToken;
    }
}

