package ar.com.sdd.agrofyapi.io;

import ar.com.sdd.agrofyapi.model.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CommonResponse extends ErrorResponse implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("className")
    private String className;

    @JsonProperty("number")
    private Integer number;

    @JsonProperty("entryType")
    private String entryType;

    @JsonProperty("created")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timezone = "GMT-03:00")
    private Date created;

    @JsonProperty("businessDate")
    private String businessDate;

    @JsonProperty("amount")
    private BigDecimal amount;

    @JsonProperty("description")
    private String description;

    @JsonProperty("comments")
    private String comments;

    @JsonProperty("state")
    private String state;

    @JsonProperty("stateDetail")
    private StateDetail stateDetail;

    @JsonProperty("transactionType")
    private String transactionType;

    @JsonProperty("saleChannel")
    private SaleChannel saleChannel;

    @JsonProperty("Channel")
    private SaleChannel channel;

    @JsonProperty("forceTransaction")
    private Boolean forceTransaction;

    @JsonProperty("account")
    private Account account;

    @JsonProperty("validations")
    private List<String> validations;

    @JsonProperty("rootTransactionNumber")
    private String rootTransactionNumber;

    @JsonProperty("rootTransactionId")
    private String rootTransactionId;

    @JsonProperty("rootTransactionType")
    private RootTransactionType rootTransactionType;

    @JsonProperty("clientTransactionId")
    private String clientTransactionId;

    @JsonProperty("clientAdditionalData")
    private ClientAdditionalData clientAdditionalData;

    @JsonProperty("confirmationId")
    private String confirmationId;

    @JsonProperty("involvedTransactions")
    private InvolvedTransactionsPaymentIntent involvedTransactions;

    @JsonProperty("product")
    private ProductPaymentIntent product;

    @JsonProperty("transactionData")
    private TransactionData transactionData;

    @JsonProperty("accessMode")
    private AccessMode accessMode;

    @JsonProperty("publicUrl")
    private String publicUrl;

    @JsonProperty("expirationDate")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timezone = "GMT-03:00")
    private Date expirationDate;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public String getEntryType() {
        return entryType;
    }

    public void setEntryType(String entryType) {
        this.entryType = entryType;
    }

    public Date getCreated() {
        return created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String getBusinessDate() {
        return businessDate;
    }

    public void setBusinessDate(String businessDate) {
        this.businessDate = businessDate;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public StateDetail getStateDetail() {
        return stateDetail;
    }

    public void setStateDetail(StateDetail stateDetail) {
        this.stateDetail = stateDetail;
    }

    public String getTransactionType() {
        return transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public SaleChannel getSaleChannel() {
        return saleChannel;
    }

    public void setSaleChannel(SaleChannel saleChannel) {
        this.saleChannel = saleChannel;
    }

    public SaleChannel getChannel() {
        return channel;
    }

    public void setChannel(SaleChannel channel) {
        this.channel = channel;
    }

    public Boolean getForceTransaction() {
        return forceTransaction;
    }

    public void setForceTransaction(Boolean forceTransaction) {
        this.forceTransaction = forceTransaction;
    }

    public Account getAccount() {
        return account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public List<String> getValidations() {
        return validations;
    }

    public void setValidations(List<String> validations) {
        this.validations = validations;
    }

    public String getRootTransactionNumber() {
        return rootTransactionNumber;
    }

    public void setRootTransactionNumber(String rootTransactionNumber) {
        this.rootTransactionNumber = rootTransactionNumber;
    }

    public String getRootTransactionId() {
        return rootTransactionId;
    }

    public void setRootTransactionId(String rootTransactionId) {
        this.rootTransactionId = rootTransactionId;
    }

    public RootTransactionType getRootTransactionType() {
        return rootTransactionType;
    }

    public void setRootTransactionType(RootTransactionType rootTransactionType) {
        this.rootTransactionType = rootTransactionType;
    }

    public String getClientTransactionId() {
        return clientTransactionId;
    }

    public void setClientTransactionId(String clientTransactionId) {
        this.clientTransactionId = clientTransactionId;
    }

    public ClientAdditionalData getClientAdditionalData() {
        return clientAdditionalData;
    }

    public void setClientAdditionalData(ClientAdditionalData clientAdditionalData) {
        this.clientAdditionalData = clientAdditionalData;
    }

    public String getConfirmationId() {
        return confirmationId;
    }

    public void setConfirmationId(String confirmationId) {
        this.confirmationId = confirmationId;
    }

    public InvolvedTransactionsPaymentIntent getInvolvedTransactions() {
        return involvedTransactions;
    }

    public void setInvolvedTransactions(InvolvedTransactionsPaymentIntent involvedTransactions) {
        this.involvedTransactions = involvedTransactions;
    }

    public ProductPaymentIntent getProduct() {
        return product;
    }

    public void setProduct(ProductPaymentIntent product) {
        this.product = product;
    }

    public TransactionData getTransactionData() {
        return transactionData;
    }

    public void setTransactionData(TransactionData transactionData) {
        this.transactionData = transactionData;
    }

    public AccessMode getAccessMode() {
        return accessMode;
    }

    public void setAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
    }

    public String getPublicUrl() {
        return publicUrl;
    }

    public void setPublicUrl(String publicUrl) {
        this.publicUrl = publicUrl;
    }

    public Date getExpirationDate() {
        return expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    @Override
    public String toString() {
        return "CommonResponse [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((className != null) ? "className='" + className + "', " : "") +
                ((number != null) ? "number=" + number + ", " : "") +
                ((entryType != null) ? "entryType='" + entryType + "', " : "") +
                ((created != null) ? "created=" + created + ", " : "") +
                ((businessDate != null) ? "businessDate='" + businessDate + "', " : "") +
                ((amount != null) ? "amount=" + amount + ", " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                ((comments != null) ? "comments='" + comments + "', " : "") +
                ((state != null) ? "state='" + state + "', " : "") +
                ((stateDetail != null) ? "stateDetail=" + stateDetail + ", " : "") +
                ((transactionType != null) ? "transactionType='" + transactionType + "', " : "") +
                ((saleChannel != null) ? "saleChannel=" + saleChannel + ", " : "") +
                ((channel != null) ? "channel=" + channel + ", " : "") +
                ((forceTransaction != null) ? "forceTransaction=" + forceTransaction + ", " : "") +
                ((account != null) ? "account=" + account + ", " : "") +
                ((validations != null) ? "validations=" + Arrays.toString(validations.toArray()) + ", " : "") +
                ((rootTransactionNumber != null) ? "rootTransactionNumber='" + rootTransactionNumber + "', " : "") +
                ((rootTransactionId != null) ? "rootTransactionId='" + rootTransactionId + "', " : "") +
                ((rootTransactionType != null) ? "rootTransactionType=" + rootTransactionType + ", " : "") +
                ((clientTransactionId != null) ? "clientTransactionId='" + clientTransactionId + "', " : "") +
                ((clientAdditionalData != null) ? "clientAdditionalData=" + clientAdditionalData + ", " : "") +
                ((confirmationId != null) ? "confirmationId='" + confirmationId + "', " : "") +
                ((involvedTransactions != null) ? "involvedTransactions=" + involvedTransactions + ", " : "") +
                ((product != null) ? "product=" + product + ", " : "") +
                ((transactionData != null) ? "transactionData=" + transactionData + ", " : "") +
                ((accessMode != null) ? "accessMode=" + accessMode + ", " : "") +
                ((publicUrl != null) ? "publicUrl='" + publicUrl + "', " : "") +
                ((expirationDate != null) ? "expirationDate=" + expirationDate + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CommonResponse that = (CommonResponse) o;
        return Objects.equals(id, that.id) && Objects.equals(className, that.className) && Objects.equals(number, that.number) && Objects.equals(entryType, that.entryType) && Objects.equals(created, that.created) && Objects.equals(businessDate, that.businessDate) && Objects.equals(amount, that.amount) && Objects.equals(description, that.description) && Objects.equals(comments, that.comments) && Objects.equals(state, that.state) && Objects.equals(stateDetail, that.stateDetail) && Objects.equals(transactionType, that.transactionType) && Objects.equals(saleChannel, that.saleChannel) && Objects.equals(channel, that.channel) && Objects.equals(forceTransaction, that.forceTransaction) && Objects.equals(account, that.account) && Objects.equals(validations, that.validations) && Objects.equals(rootTransactionNumber, that.rootTransactionNumber) && Objects.equals(rootTransactionId, that.rootTransactionId) && Objects.equals(rootTransactionType, that.rootTransactionType) && Objects.equals(clientTransactionId, that.clientTransactionId) && Objects.equals(clientAdditionalData, that.clientAdditionalData) && Objects.equals(confirmationId, that.confirmationId) && Objects.equals(involvedTransactions, that.involvedTransactions) && Objects.equals(product, that.product) && Objects.equals(transactionData, that.transactionData) && Objects.equals(accessMode, that.accessMode) && Objects.equals(publicUrl, that.publicUrl) && Objects.equals(expirationDate, that.expirationDate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), id, className, number, entryType, created, businessDate, amount, description, comments, state, stateDetail, transactionType, saleChannel, channel, forceTransaction, account, validations, rootTransactionNumber, rootTransactionId, rootTransactionType, clientTransactionId, clientAdditionalData, confirmationId, involvedTransactions, product, transactionData, accessMode, publicUrl, expirationDate);
    }
}
