package ar.com.sdd.agrofyapi.io;

import ar.com.sdd.agrofyapi.model.webhook.EventsDeserializer;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CreateWebhookRequest implements Serializable {

    @JsonProperty("enable")
    private Boolean enable;

    @JsonProperty("eventsHierarchical")
    private Boolean eventsHierarchical;

    @JsonProperty("endpointUrl")
    private String endpointUrl;

    @JsonDeserialize(using = EventsDeserializer.class)
    @JsonProperty("events")
    private List<EventsDeserializer.Events> events;

    @JsonProperty("description")
    private String description;


    public Boolean getEnable() {
        return enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public Boolean getEventsHierarchical() {
        return eventsHierarchical;
    }

    public void setEventsHierarchical(Boolean eventsHierarchical) {
        this.eventsHierarchical = eventsHierarchical;
    }

    public String getEndpointUrl() {
        return endpointUrl;
    }

    public void setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    public List<EventsDeserializer.Events> getEvents() {
        return events;
    }

    public void setEvents(List<EventsDeserializer.Events> events) {
        this.events = events;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        return "CreateWebhookRequest [" +
                ((enable != null) ? "enable=" + enable + ", " : "") +
                ((eventsHierarchical != null) ? "eventsHierarchical=" + eventsHierarchical + ", " : "") +
                ((endpointUrl != null) ? "endpointUrl='" + endpointUrl + "', " : "") +
                ((events != null) ? "events=" + Arrays.toString(events.toArray()) + ", " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CreateWebhookRequest that = (CreateWebhookRequest) o;
        return Objects.equals(enable, that.enable) && Objects.equals(eventsHierarchical, that.eventsHierarchical) && Objects.equals(endpointUrl, that.endpointUrl) && Objects.equals(events, that.events) && Objects.equals(description, that.description);
    }

    @Override
    public int hashCode() {
        return Objects.hash(enable, eventsHierarchical, endpointUrl, events, description);
    }
}
