package ar.com.sdd.agrofyapi.io;

import ar.com.sdd.agrofyapi.model.AvailablesPaymentMethod;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PaymentIntentRequest implements Serializable {

    @JsonProperty("amount")
    private BigDecimal amount;

    @JsonProperty("clientTransactionId")
    private String clientTransactionId;

    @JsonProperty("comments")
    private String comments;

    @JsonProperty("expirationDate")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timezone = "GMT-03:00")
    private Date expirationDate;

    @JsonProperty("availablesPaymentMethod")
    private List<AvailablesPaymentMethod> availablesPaymentMethod;


    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getClientTransactionId() {
        return clientTransactionId;
    }

    public void setClientTransactionId(String clientTransactionId) {
        this.clientTransactionId = clientTransactionId;
    }

    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Date getExpirationDate() {
        return expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public List<AvailablesPaymentMethod> getAvailablesPaymentMethod() {
        return availablesPaymentMethod;
    }

    public void setAvailablesPaymentMethod(List<AvailablesPaymentMethod> availablesPaymentMethod) {
        this.availablesPaymentMethod = availablesPaymentMethod;
    }

    @Override
    public String toString() {
        return "CreatePaymentLinkRequest [" +
                ((amount != null) ? "amount=" + amount + ", " : "") +
                ((clientTransactionId != null) ? "clientTransactionId='" + clientTransactionId + "', " : "") +
                ((comments != null) ? "comments='" + comments + "', " : "") +
                ((expirationDate != null) ? "expirationDate=" + expirationDate + ", " : "") +
                ((availablesPaymentMethod != null) ? "availablesPaymentMethod=" + Arrays.toString(availablesPaymentMethod.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PaymentIntentRequest that = (PaymentIntentRequest) o;
        return Objects.equals(amount, that.amount) && Objects.equals(clientTransactionId, that.clientTransactionId) && Objects.equals(comments, that.comments) && Objects.equals(expirationDate, that.expirationDate) && Objects.equals(availablesPaymentMethod, that.availablesPaymentMethod);
    }

    @Override
    public int hashCode() {
        return Objects.hash(amount, clientTransactionId, comments, expirationDate, availablesPaymentMethod);
    }
}
