package ar.com.sdd.agrofyapi.io;

import ar.com.sdd.agrofyapi.model.webhook.EventsDeserializer;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class WebhookResponse implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("creationdate")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone = "GMT-03:00")
    private Date creationdate;

    @JsonProperty("enable")
    private Boolean enable;

    @JsonProperty("className")
    private String className;

    @JsonProperty("version")
    private Integer version;

    @JsonProperty("accountId")
    private String accountId;

    @JsonProperty("applicationUserId")
    private String applicationUserId;

    @JsonProperty("description")
    private String description;

    @JsonProperty("eventsHierarchical")
    private Boolean eventsHierarchical;

    @JsonDeserialize(using = EventsDeserializer.class)
    @JsonProperty("events")
    private List<EventsDeserializer.Events> events;

    @JsonProperty("endpointUrl")
    private String endpointUrl;

    @JsonProperty("code")
    private String code;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getCreationdate() {
        return creationdate;
    }

    public void setCreationdate(Date creationdate) {
        this.creationdate = creationdate;
    }

    public Boolean getEnable() {
        return enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Integer getVersion() {
        return version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getAccountId() {
        return accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getApplicationUserId() {
        return applicationUserId;
    }

    public void setApplicationUserId(String applicationUserId) {
        this.applicationUserId = applicationUserId;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getEventsHierarchical() {
        return eventsHierarchical;
    }

    public void setEventsHierarchical(Boolean eventsHierarchical) {
        this.eventsHierarchical = eventsHierarchical;
    }

    public List<EventsDeserializer.Events> getEvents() {
        return events;
    }

    public void setEvents(List<EventsDeserializer.Events> events) {
        this.events = events;
    }

    public String getEndpointUrl() {
        return endpointUrl;
    }

    public void setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String toString() {
        return "WebhookResponse [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((creationdate != null) ? "creationdate=" + creationdate + ", " : "") +
                ((enable != null) ? "enable=" + enable + ", " : "") +
                ((className != null) ? "className='" + className + "', " : "") +
                ((version != null) ? "version=" + version + ", " : "") +
                ((accountId != null) ? "accountId='" + accountId + "', " : "") +
                ((applicationUserId != null) ? "applicationUserId='" + applicationUserId + "', " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                ((eventsHierarchical != null) ? "eventsHierarchical=" + eventsHierarchical + ", " : "") +
                ((events != null) ? "events=" + Arrays.toString(events.toArray()) + ", " : "") +
                ((endpointUrl != null) ? "endpointUrl='" + endpointUrl + "', " : "") +
                ((code != null) ? "code='" + code + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        WebhookResponse that = (WebhookResponse) o;
        return Objects.equals(id, that.id) && Objects.equals(creationdate, that.creationdate) && Objects.equals(enable, that.enable) && Objects.equals(className, that.className) && Objects.equals(version, that.version) && Objects.equals(accountId, that.accountId) && Objects.equals(applicationUserId, that.applicationUserId) && Objects.equals(description, that.description) && Objects.equals(eventsHierarchical, that.eventsHierarchical) && Objects.equals(events, that.events) && Objects.equals(endpointUrl, that.endpointUrl) && Objects.equals(code, that.code);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, creationdate, enable, className, version, accountId, applicationUserId, description, eventsHierarchical, events, endpointUrl, code);
    }
}
