package ar.com.sdd.agrofyapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Account implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("name")
    private String name;

    @JsonProperty("accountNumber")
    private Integer accountNumber;

    @JsonProperty("businessName")
    private String businessName;

    @JsonProperty("holdingAccount")
    private HoldingAccount holdingAccount;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(Integer accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getBusinessName() {
        return businessName;
    }

    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    public HoldingAccount getHoldingAccount() {
        return holdingAccount;
    }

    public void setHoldingAccount(HoldingAccount holdingAccount) {
        this.holdingAccount = holdingAccount;
    }

    @Override
    public String toString() {
        return "Account [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((name != null) ? "name='" + name + "', " : "") +
                ((accountNumber != null) ? "accountNumber=" + accountNumber + ", " : "") +
                ((businessName != null) ? "businessName='" + businessName + "', " : "") +
                ((holdingAccount != null) ? "holdingAccount=" + holdingAccount + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Account account = (Account) o;
        return Objects.equals(id, account.id) && Objects.equals(name, account.name) && Objects.equals(accountNumber, account.accountNumber) && Objects.equals(businessName, account.businessName) && Objects.equals(holdingAccount, account.holdingAccount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, accountNumber, businessName, holdingAccount);
    }
}
