package ar.com.sdd.agrofyapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ClientAdditionalData implements Serializable {

    @JsonProperty("transactionCode")
    private String transactionCode;


    public String getTransactionCode() {
        return transactionCode;
    }

    public void setTransactionCode(String transactionCode) {
        this.transactionCode = transactionCode;
    }

    @Override
    public String toString() {
        return "ClientAdditionalData [" +
                ((transactionCode != null) ? "transactionCode='" + transactionCode + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ClientAdditionalData that = (ClientAdditionalData) o;
        return Objects.equals(transactionCode, that.transactionCode);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(transactionCode);
    }
}
