package ar.com.sdd.agrofyapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class From implements Serializable {

    @JsonProperty("bank_id")
    private String bank_id;

    @JsonProperty("account_id")
    private String account_id;


    public String getBank_id() {
        return bank_id;
    }

    public void setBank_id(String bank_id) {
        this.bank_id = bank_id;
    }

    public String getAccount_id() {
        return account_id;
    }

    public void setAccount_id(String account_id) {
        this.account_id = account_id;
    }

    @Override
    public String toString() {
        return "From [" +
                ((bank_id != null) ? "bank_id='" + bank_id + "', " : "") +
                ((account_id != null) ? "account_id='" + account_id + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        From from = (From) o;
        return Objects.equals(bank_id, from.bank_id) && Objects.equals(account_id, from.account_id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(bank_id, account_id);
    }
}
