package ar.com.sdd.agrofyapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class GvpErrorDescription implements Serializable {

    @JsonProperty("errorCode")
    private Integer errorCode;

    @JsonProperty("errortype")
    private String errortype;

    @JsonProperty("messageText")
    private String messageText;


    public Integer getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrortype() {
        return errortype;
    }

    public void setErrortype(String errortype) {
        this.errortype = errortype;
    }

    public String getMessageText() {
        return messageText;
    }

    public void setMessageText(String messageText) {
        this.messageText = messageText;
    }

    @Override
    public String toString() {
        return "GvpErrorDescription [" +
                ((errorCode != null) ? "errorCode=" + errorCode + ", " : "") +
                ((errortype != null) ? "errortype='" + errortype + "', " : "") +
                ((messageText != null) ? "messageText='" + messageText + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GvpErrorDescription that = (GvpErrorDescription) o;
        return Objects.equals(errorCode, that.errorCode) && Objects.equals(errortype, that.errortype) && Objects.equals(messageText, that.messageText);
    }

    @Override
    public int hashCode() {
        return Objects.hash(errorCode, errortype, messageText);
    }
}
