package ar.com.sdd.agrofyapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class TransactionData implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("className")
    private String className;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public String toString() {
        return "TransactionData [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((className != null) ? "className='" + className + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TransactionData that = (TransactionData) o;
        return Objects.equals(id, that.id) && Objects.equals(className, that.className);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, className);
    }
}
