package ar.com.sdd.agrofyapi.model.webhook;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

import java.io.IOException;

public class EventsDeserializer extends JsonDeserializer<EventsDeserializer.Events> {

    public enum Events {
        TRANSACTIONS_PAYMENTINTENT_CREATED("transactions.PaymentIntent.Created"), // Se genera cuando se crea un link de pago (PaymentIntent)
        TRANSACTIONS_PAYMENTINTENT_REJECTED("transactions.PaymentIntent.Rejected"), // Se genera cuando un link de pago queda expirado y no puede ser mas pagado
        TRANSACTIONS_PAYMENTCLIENT_REJECTED("transactions.PaymentClient.Rejected"), // Se genera cuando un link de pago tiene un pago rechazado
        TRANSACTIONS_PAYMENTCLIENTREFUND_CONFIRMED("transactions.PaymentClientRefund.Confirmed"), // Se genera cuando un link de pago tiene un pago aprobado
        TRANSACTIONS_PAYMENTCLIENTREVERSE_CONFIRMED("transactions.PaymentClientReverse.Confirmed"), // Se genera cuando un pago aprobado tiene una devolución por parte del vendedor
        TRANSACTIONS_PAYMENTCLIENT_CONFIRMED("transactions.PaymentClient.Confirmed"); // Se genera cuando un pago aprobado tiene un contracargo por parte del pagador

        private final String displayName;

        Events(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    @Override
    public Events deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String value = p.getValueAsString();
        for (Events event : Events.values()) {
            if (event.getDisplayName().equals(value)) {
                return event;
            }
        }
        throw new IllegalArgumentException("Value invalido para Events: " + value);
    }
}