package ar.com.sdd.agrofyapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Data implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("type")
    private String type;

    @JsonProperty("from")
    private From from;

    @JsonProperty("counterParty")
    private CounterParty counterParty;

    @JsonProperty("details")
    private Details details;

    @JsonProperty("transaction_ids")
    private List<String> transaction_ids;

    @JsonProperty("status")
    private String status;

    @JsonProperty("start_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone = "GMT-03:00")
    private Date start_date;

    @JsonProperty("end_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone = "GMT-03:00")
    private Date end_date;

    @JsonProperty("charge")
    private String charge;

    @JsonProperty("business_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone = "GMT-03:00")
    private Date business_date;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public From getFrom() {
        return from;
    }

    public void setFrom(From from) {
        this.from = from;
    }

    public CounterParty getCounterParty() {
        return counterParty;
    }

    public void setCounterParty(CounterParty counterParty) {
        this.counterParty = counterParty;
    }

    public Details getDetails() {
        return details;
    }

    public void setDetails(Details details) {
        this.details = details;
    }

    public List<String> getTransaction_ids() {
        return transaction_ids;
    }

    public void setTransaction_ids(List<String> transaction_ids) {
        this.transaction_ids = transaction_ids;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getStart_date() {
        return start_date;
    }

    public void setStart_date(Date start_date) {
        this.start_date = start_date;
    }

    public Date getEnd_date() {
        return end_date;
    }

    public void setEnd_date(Date end_date) {
        this.end_date = end_date;
    }

    public String getCharge() {
        return charge;
    }

    public void setCharge(String charge) {
        this.charge = charge;
    }

    public Date getBusiness_date() {
        return business_date;
    }

    public void setBusiness_date(Date business_date) {
        this.business_date = business_date;
    }

    @Override
    public String toString() {
        return "Data [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((type != null) ? "type='" + type + "', " : "") +
                ((from != null) ? "from=" + from + ", " : "") +
                ((counterParty != null) ? "counterParty=" + counterParty + ", " : "") +
                ((details != null) ? "details=" + details + ", " : "") +
                ((transaction_ids != null) ? "transaction_ids=" + Arrays.toString(transaction_ids.toArray()) + ", " : "") +
                ((status != null) ? "status='" + status + "', " : "") +
                ((start_date != null) ? "start_date=" + start_date + ", " : "") +
                ((end_date != null) ? "end_date=" + end_date + ", " : "") +
                ((charge != null) ? "charge='" + charge + "', " : "") +
                ((business_date != null) ? "business_date=" + business_date + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Data data = (Data) o;
        return Objects.equals(id, data.id) && Objects.equals(type, data.type) && Objects.equals(from, data.from) && Objects.equals(counterParty, data.counterParty) && Objects.equals(details, data.details) && Objects.equals(transaction_ids, data.transaction_ids) && Objects.equals(status, data.status) && Objects.equals(start_date, data.start_date) && Objects.equals(end_date, data.end_date) && Objects.equals(charge, data.charge) && Objects.equals(business_date, data.business_date);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, type, from, counterParty, details, transaction_ids, status, start_date, end_date, charge, business_date);
    }
}
