package ar.com.sdd.agrofyapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Details implements Serializable {

    @JsonProperty("origin_credit")
    private OriginCredit origin_credit;


    public OriginCredit getOrigin_credit() {
        return origin_credit;
    }

    public void setOrigin_credit(OriginCredit origin_credit) {
        this.origin_credit = origin_credit;
    }

    @Override
    public String toString() {
        return "Details [" +
                ((origin_credit != null) ? "origin_credit=" + origin_credit + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Details details = (Details) o;
        return Objects.equals(origin_credit, details.origin_credit);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(origin_credit);
    }
}
