package ar.com.sdd.agrofyapi.model;

import ar.com.sdd.agrofyapi.model.utils.EnumDeserializer;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProductGroup implements Serializable {

    public enum Description {
        RECARGAS_TELEFONICAS("Recargas Telefonicas"),
        TV_PREPAGA("TV Prepaga"),
        TRANSPORTE("Transporte"),
        NORMAL("Normal");

        private final String displayName;

        Description(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    @JsonProperty("id")
    private String id;

    @JsonDeserialize(using = EnumDeserializer.class)
    @JsonProperty("description")
    private Description description;

    @JsonProperty("name")
    private String name;

    @JsonProperty("code")
    private String code;

    @JsonProperty("enable")
    private Boolean enable;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Description getDescription() {
        return description;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Boolean getEnable() {
        return enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Override
    public String toString() {
        return "ProductGroup [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((description != null) ? "description=" + description + ", " : "") +
                ((name != null) ? "name='" + name + "', " : "") +
                ((code != null) ? "code='" + code + "', " : "") +
                ((enable != null) ? "enable=" + enable + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ProductGroup that = (ProductGroup) o;
        return Objects.equals(id, that.id) && description == that.description && Objects.equals(name, that.name) && Objects.equals(code, that.code) && Objects.equals(enable, that.enable);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, description, name, code, enable);
    }
}
