package ar.com.sdd.agrofyapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProductPaymentIntent implements Serializable {

    public enum TransactionDataClassName {
        PhoneData,
        CodeData,
        BillPaymentData,
        ParkingData,
        PersonalData,
        WithoutData,
        PayoutData
    }

    @JsonProperty("id")
    private String id;

    @JsonProperty("name")
    private String name;

    @JsonProperty("code")
    private String code;

    @JsonProperty("enable")
    private Boolean enable;

    @JsonProperty("smallDescription")
    private String smallDescription;

    @JsonProperty("className")
    private String className;

    @JsonProperty("vendor")
    private Vendor vendor;

    @JsonProperty("productGroup")
    private ProductGroup productGroup;

    @JsonProperty("minimium")
    private Integer minimium;

    @JsonProperty("maximium")
    private Integer maximium;

    @JsonProperty("imageUrl")
    private String imageUrl;

    @JsonProperty("productType")
    private String productType;

    @JsonProperty("transactionDataClassName")
    private TransactionDataClassName transactionDataClassName;

    @JsonProperty("salePrice")
    private Integer salePrice;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Boolean getEnable() {
        return enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public String getSmallDescription() {
        return smallDescription;
    }

    public void setSmallDescription(String smallDescription) {
        this.smallDescription = smallDescription;
    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Vendor getVendor() {
        return vendor;
    }

    public void setVendor(Vendor vendor) {
        this.vendor = vendor;
    }

    public ProductGroup getProductGroup() {
        return productGroup;
    }

    public void setProductGroup(ProductGroup productGroup) {
        this.productGroup = productGroup;
    }

    public Integer getMinimium() {
        return minimium;
    }

    public void setMinimium(Integer minimium) {
        this.minimium = minimium;
    }

    public Integer getMaximium() {
        return maximium;
    }

    public void setMaximium(Integer maximium) {
        this.maximium = maximium;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getProductType() {
        return productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public TransactionDataClassName getTransactionDataClassName() {
        return transactionDataClassName;
    }

    public void setTransactionDataClassName(TransactionDataClassName transactionDataClassName) {
        this.transactionDataClassName = transactionDataClassName;
    }

    public Integer getSalePrice() {
        return salePrice;
    }

    public void setSalePrice(Integer salePrice) {
        this.salePrice = salePrice;
    }

    @Override
    public String toString() {
        return "ProductPaymentIntent [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((name != null) ? "name='" + name + "', " : "") +
                ((code != null) ? "code='" + code + "', " : "") +
                ((enable != null) ? "enable=" + enable + ", " : "") +
                ((smallDescription != null) ? "smallDescription='" + smallDescription + "', " : "") +
                ((className != null) ? "className='" + className + "', " : "") +
                ((vendor != null) ? "vendor=" + vendor + ", " : "") +
                ((productGroup != null) ? "productGroup=" + productGroup + ", " : "") +
                ((minimium != null) ? "minimium=" + minimium + ", " : "") +
                ((maximium != null) ? "maximium=" + maximium + ", " : "") +
                ((imageUrl != null) ? "imageUrl='" + imageUrl + "', " : "") +
                ((productType != null) ? "productType='" + productType + "', " : "") +
                ((transactionDataClassName != null) ? "transactionDataClassName=" + transactionDataClassName + ", " : "") +
                ((salePrice != null) ? "salePrice=" + salePrice + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ProductPaymentIntent that = (ProductPaymentIntent) o;
        return Objects.equals(id, that.id) && Objects.equals(name, that.name) && Objects.equals(code, that.code) && Objects.equals(enable, that.enable) && Objects.equals(smallDescription, that.smallDescription) && Objects.equals(className, that.className) && Objects.equals(vendor, that.vendor) && Objects.equals(productGroup, that.productGroup) && Objects.equals(minimium, that.minimium) && Objects.equals(maximium, that.maximium) && Objects.equals(imageUrl, that.imageUrl) && Objects.equals(productType, that.productType) && transactionDataClassName == that.transactionDataClassName && Objects.equals(salePrice, that.salePrice);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, code, enable, smallDescription, className, vendor, productGroup, minimium, maximium, imageUrl, productType, transactionDataClassName, salePrice);
    }
}
