package ar.com.sdd.agrofyapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class StateDetail implements Serializable {

    @JsonProperty("message")
    private String message;

    @JsonProperty("transactionType")
    private String transactionType;

    @JsonProperty("statusResponseCode")
    private StatusResponseCode statusResponseCode;

    @JsonProperty("originRejectedType")
    private String originRejectedType;


    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getTransactionType() {
        return transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public StatusResponseCode getStatusResponseCode() {
        return statusResponseCode;
    }

    public void setStatusResponseCode(StatusResponseCode statusResponseCode) {
        this.statusResponseCode = statusResponseCode;
    }

    public String getOriginRejectedType() {
        return originRejectedType;
    }

    public void setOriginRejectedType(String originRejectedType) {
        this.originRejectedType = originRejectedType;
    }

    @Override
    public String toString() {
        return "StateDetail [" +
                ((message != null) ? "message='" + message + "', " : "") +
                ((transactionType != null) ? "transactionType='" + transactionType + "', " : "") +
                ((statusResponseCode != null) ? "statusResponseCode=" + statusResponseCode + ", " : "") +
                ((originRejectedType != null) ? "originRejectedType='" + originRejectedType + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        StateDetail that = (StateDetail) o;
        return Objects.equals(message, that.message) && Objects.equals(transactionType, that.transactionType) && Objects.equals(statusResponseCode, that.statusResponseCode) && Objects.equals(originRejectedType, that.originRejectedType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(message, transactionType, statusResponseCode, originRejectedType);
    }
}
