package ar.com.sdd.agrofyapi.model.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class EnumDeserializer<T extends Enum<T>> extends JsonDeserializer<Object> {

    private final Class<T> enumType;

    public EnumDeserializer(Class<T> enumType) {
        this.enumType = enumType;
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken token = p.currentToken();

        // Si es un Array
        if (token == JsonToken.START_ARRAY) {
            List<T> enums = new ArrayList<>();
            while (p.nextToken() != JsonToken.END_ARRAY) {
                enums.add(parseEnum(p.getValueAsString()));
            }
            return enums;
        }

        // Si espero un unico valor
        if (token == JsonToken.VALUE_STRING) {
            return parseEnum(p.getValueAsString());
        }

        throw ctxt.mappingException("No se puede deserializar el valor como Enum o Lista de Enums");
    }

    private T parseEnum(String value) {
        for (T enumConstant : enumType.getEnumConstants()) {
            if (enumConstant.toString().equals(value)) {
                return enumConstant;
            }
        }
        throw new IllegalArgumentException("Valor invalido para el enum " + enumType.getSimpleName() + ": " + value);
    }
}
