package ar.com.sdd.agrofyapi.model.webhook;

public enum Events {
    TRANSACTIONS_PAYMENTINTENT_CREATED("transactions.PaymentIntent.Created"), // Se genera cuando se crea un link de pago (PaymentIntent)
    TRANSACTIONS_PAYMENTINTENT_REJECTED("transactions.PaymentIntent.Rejected"), // Se genera cuando un link de pago queda expirado y no puede ser mas pagado
    TRANSACTIONS_PAYMENTCLIENT_REJECTED("transactions.PaymentClient.Rejected"), // Se genera cuando un link de pago tiene un pago rechazado
    TRANSACTIONS_PAYMENTCLIENTREFUND_CONFIRMED("transactions.PaymentClientRefund.Confirmed"), // Se genera cuando un link de pago tiene un pago aprobado
    TRANSACTIONS_PAYMENTCLIENTREVERSE_CONFIRMED("transactions.PaymentClientReverse.Confirmed"), // Se genera cuando un pago aprobado tiene una devolución por parte del vendedor
    TRANSACTIONS_PAYMENTCLIENT_CONFIRMED("transactions.PaymentClient.Confirmed"); // Se genera cuando un pago aprobado tiene un contracargo por parte del pagador

    private final String displayName;

    Events(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}
