/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.agrofyapi.model.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.ArrayList;

public class EnumDeserializer<T extends Enum<T>>
extends JsonDeserializer<Object> {
    private final Class<T> enumType;

    public EnumDeserializer(Class<T> enumType) {
        this.enumType = enumType;
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken token = p.currentToken();
        if (token == JsonToken.START_ARRAY) {
            ArrayList<T> enums = new ArrayList<T>();
            while (p.nextToken() != JsonToken.END_ARRAY) {
                enums.add(this.parseEnum(p.getValueAsString()));
            }
            return enums;
        }
        if (token == JsonToken.VALUE_STRING) {
            return this.parseEnum(p.getValueAsString());
        }
        throw ctxt.mappingException("No se puede deserializar el valor como Enum o Lista de Enums");
    }

    private T parseEnum(String value) {
        for (Enum enumConstant : (Enum[])this.enumType.getEnumConstants()) {
            if (!enumConstant.toString().equals(value)) continue;
            return (T)enumConstant;
        }
        throw new IllegalArgumentException("Valor invalido para el enum " + this.enumType.getSimpleName() + ": " + value);
    }
}

