/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.agropagoapi.core;

import ar.com.sdd.agropagoapi.core.AgropagoApiConnectorContext;
import ar.com.sdd.agropagoapi.io.ConsultarLinkResponse;
import ar.com.sdd.agropagoapi.io.CrarLinkRequest;
import ar.com.sdd.agropagoapi.io.CrearLinkResponse;
import ar.com.sdd.agropagoapi.model.CommonError;
import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import javax.ws.rs.client.Invocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AgropagoApiConnector
implements RestSecurityManager {
    private static final Logger log = LogManager.getLogger(AgropagoApiConnector.class);
    private final RestConnector restConnector;
    private final String xApiKey;
    private final String customerId;

    public AgropagoApiConnector(AgropagoApiConnectorContext context) {
        this.xApiKey = context.getXApiKey();
        this.customerId = context.getCustomerId();
        log.debug("Creando PatagoniaApiConnector con " + String.valueOf(context));
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public CrearLinkResponse crearLink(CrarLinkRequest request) throws RestConnectorException {
        String path = "/integration/paymentLink?customerId=" + this.customerId;
        return (CrearLinkResponse)this.restConnector.genericPost((Object)request, CrearLinkResponse.class, CommonError.class, path);
    }

    public ConsultarLinkResponse consultarLink(int paymentLinkId) throws RestConnectorException {
        String path = "/integration/paymentLink/" + paymentLinkId;
        return (ConsultarLinkResponse)this.restConnector.genericGet(null, ConsultarLinkResponse.class, CommonError.class, path);
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("x-application-key", (Object)this.xApiKey);
        }
        return builder;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }
}

