package ar.com.sdd.agropagoapi.io;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CrearLinkRequest implements Serializable {

    @JsonProperty("payerCuit")
    private String payerCuit;

    @JsonProperty("amount")
    private BigDecimal amount;

    @JsonProperty("description")
    private String description;

    @JsonProperty("expirationDate")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date expirationDate;

    @JsonProperty("urlRedirect")
    private String urlRedirect;

    public String getPayerCuit() {
        return payerCuit;
    }

    public void setPayerCuit(String payerCuit) {
        this.payerCuit = payerCuit;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getExpirationDate() {
        return expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getUrlRedirect() {
        return urlRedirect;
    }

    public void setUrlRedirect(String urlRedirect) {
        this.urlRedirect = urlRedirect;
    }

    @Override
    public String toString() {
        return "CreateLinkRequest [" +
                ((payerCuit != null) ? "payerCuit='" + payerCuit + "', " : "") +
                ((amount != null) ? "amount=" + amount + ", " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                ((expirationDate != null) ? "expirationDate=" + expirationDate + ", " : "") +
                ((urlRedirect != null) ? "urlRedirect='" + urlRedirect + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CrearLinkRequest that = (CrearLinkRequest) o;
        return Objects.equals(payerCuit, that.payerCuit) && Objects.equals(amount, that.amount) && Objects.equals(description, that.description) && Objects.equals(expirationDate, that.expirationDate) && Objects.equals(urlRedirect, that.urlRedirect);
    }

    @Override
    public int hashCode() {
        return Objects.hash(payerCuit, amount, description, expirationDate, urlRedirect);
    }
}