package ar.com.sdd.agropagoapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Transaction implements Serializable {

    @JsonProperty("id")
    private Integer id;

    @JsonProperty("operationId")
    private String operationId;

    @JsonProperty("paymentDetail")
    private String paymentDetail;

    @JsonProperty("paymentMethodName")
    private String paymentMethodName;

    @JsonProperty("amount")
    private String amount;

    @JsonProperty("daysAgreement")
    private Integer daysAgreement;

    @JsonProperty("installmentsDate")
    private String installmentsDate;

    @JsonProperty("statusId")
    private Integer statusId;

    @JsonProperty("statusDesc")
    private String statusDesc;

    @JsonProperty("email")
    private String email;

    @JsonProperty("titular")
    private String titular;

    @JsonProperty("bin")
    private Integer bin;

    @JsonProperty("lastFourDigits")
    private String lastFourDigits;

    @JsonProperty("expirationMonth")
    private Integer expirationMonth;

    @JsonProperty("expirationYear")
    private Integer expirationYear;

    @JsonProperty("authCode")
    private String authCode;

    @JsonProperty("ticket")
    private String ticket;

    @JsonProperty("statusErrorReason")
    private String statusErrorReason;

    @JsonProperty("createdAt")
    private String createdAt;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getOperationId() {
        return operationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public String getPaymentDetail() {
        return paymentDetail;
    }

    public void setPaymentDetail(String paymentDetail) {
        this.paymentDetail = paymentDetail;
    }

    public String getPaymentMethodName() {
        return paymentMethodName;
    }

    public void setPaymentMethodName(String paymentMethodName) {
        this.paymentMethodName = paymentMethodName;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public Integer getDaysAgreement() {
        return daysAgreement;
    }

    public void setDaysAgreement(Integer daysAgreement) {
        this.daysAgreement = daysAgreement;
    }

    public String getInstallmentsDate() {
        return installmentsDate;
    }

    public void setInstallmentsDate(String installmentsDate) {
        this.installmentsDate = installmentsDate;
    }

    public Integer getStatusId() {
        return statusId;
    }

    public void setStatusId(Integer statusId) {
        this.statusId = statusId;
    }

    public String getStatusDesc() {
        return statusDesc;
    }

    public void setStatusDesc(String statusDesc) {
        this.statusDesc = statusDesc;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getTitular() {
        return titular;
    }

    public void setTitular(String titular) {
        this.titular = titular;
    }

    public Integer getBin() {
        return bin;
    }

    public void setBin(Integer bin) {
        this.bin = bin;
    }

    public String getLastFourDigits() {
        return lastFourDigits;
    }

    public void setLastFourDigits(String lastFourDigits) {
        this.lastFourDigits = lastFourDigits;
    }

    public Integer getExpirationMonth() {
        return expirationMonth;
    }

    public void setExpirationMonth(Integer expirationMonth) {
        this.expirationMonth = expirationMonth;
    }

    public Integer getExpirationYear() {
        return expirationYear;
    }

    public void setExpirationYear(Integer expirationYear) {
        this.expirationYear = expirationYear;
    }

    public String getAuthCode() {
        return authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public String getTicket() {
        return ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public String getStatusErrorReason() {
        return statusErrorReason;
    }

    public void setStatusErrorReason(String statusErrorReason) {
        this.statusErrorReason = statusErrorReason;
    }

    public String getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    @Override
    public String toString() {
        return "Transaction [" +
                ((id != null) ? "id=" + id + ", " : "") +
                ((operationId != null) ? "operationId='" + operationId + "', " : "") +
                ((paymentDetail != null) ? "paymentDetail='" + paymentDetail + "', " : "") +
                ((paymentMethodName != null) ? "paymentMethodName='" + paymentMethodName + "', " : "") +
                ((amount != null) ? "amount='" + amount + "', " : "") +
                ((daysAgreement != null) ? "daysAgreement=" + daysAgreement + ", " : "") +
                ((installmentsDate != null) ? "installmentsDate='" + installmentsDate + "', " : "") +
                ((statusId != null) ? "statusId=" + statusId + ", " : "") +
                ((statusDesc != null) ? "statusDesc='" + statusDesc + "', " : "") +
                ((email != null) ? "email='" + email + "', " : "") +
                ((titular != null) ? "titular='" + titular + "', " : "") +
                ((bin != null) ? "bin=" + bin + ", " : "") +
                ((lastFourDigits != null) ? "lastFourDigits='" + lastFourDigits + "', " : "") +
                ((expirationMonth != null) ? "expirationMonth=" + expirationMonth + ", " : "") +
                ((expirationYear != null) ? "expirationYear=" + expirationYear + ", " : "") +
                ((authCode != null) ? "authCode='" + authCode + "', " : "") +
                ((ticket != null) ? "ticket='" + ticket + "', " : "") +
                ((statusErrorReason != null) ? "statusErrorReason='" + statusErrorReason + "', " : "") +
                ((createdAt != null) ? "createdAt='" + createdAt + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Transaction that = (Transaction) o;
        return Objects.equals(id, that.id) && Objects.equals(operationId, that.operationId) && Objects.equals(paymentDetail, that.paymentDetail) && Objects.equals(paymentMethodName, that.paymentMethodName) && Objects.equals(amount, that.amount) && Objects.equals(daysAgreement, that.daysAgreement) && Objects.equals(installmentsDate, that.installmentsDate) && Objects.equals(statusId, that.statusId) && Objects.equals(statusDesc, that.statusDesc) && Objects.equals(email, that.email) && Objects.equals(titular, that.titular) && Objects.equals(bin, that.bin) && Objects.equals(lastFourDigits, that.lastFourDigits) && Objects.equals(expirationMonth, that.expirationMonth) && Objects.equals(expirationYear, that.expirationYear) && Objects.equals(authCode, that.authCode) && Objects.equals(ticket, that.ticket) && Objects.equals(statusErrorReason, that.statusErrorReason) && Objects.equals(createdAt, that.createdAt);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, operationId, paymentDetail, paymentMethodName, amount, daysAgreement, installmentsDate, statusId, statusDesc, email, titular, bin, lastFourDigits, expirationMonth, expirationYear, authCode, ticket, statusErrorReason, createdAt);
    }
}