package ar.com.sdd.agropagoapi.core;

import ar.com.sdd.agropagoapi.io.ConsultarLinkResponse;
import ar.com.sdd.agropagoapi.io.CrearLinkRequest;
import ar.com.sdd.agropagoapi.io.CrearLinkResponse;
import ar.com.sdd.agropagoapi.model.CommonError;
import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import javax.ws.rs.client.Invocation;

public class AgropagoApiConnector implements RestSecurityManager {

    private final static Logger log = LogManager.getLogger(AgropagoApiConnector.class);

    private final RestConnector restConnector;

    private final String xApiKey;
    private final String customerId;

    public AgropagoApiConnector(AgropagoApiConnectorContext context) {
        this.xApiKey = context.getXApiKey();
        this.customerId = context.getCustomerId();

        log.debug("Creando PatagoniaApiConnector con " + context);
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        restConnector = new RestConnector(environment, this);
    }

    public CrearLinkResponse crearLink(CrearLinkRequest request) throws RestConnectorException {
        final String path = "/integration/paymentLink?customerId=" + customerId;
        return restConnector.genericPost(request, CrearLinkResponse.class, CommonError.class, path);
    }

    public ConsultarLinkResponse consultarLink(int paymentLinkId) throws RestConnectorException {
        final String path = "/integration/paymentLink/" + paymentLinkId;
        return restConnector.genericGet(null, ConsultarLinkResponse.class, CommonError.class, path);
    }

    public void eliminarLink(int paymentLinkId) throws RestConnectorException {
        final String path = "/integration/paymentLink/" + paymentLinkId;
        restConnector.genericDelete(null, Void.class, CommonError.class, path, null);
    }

    @Override
    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("x-api-key", xApiKey);
        }
        return builder;
    }

    @Override
    public boolean getDisableHTTPSErrors() {
        return false;
    }
}