package ar.com.sdd.agropagoapi.io;

import ar.com.sdd.agropagoapi.model.Transaction;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ConsultarLinkResponse implements Serializable {

    @JsonProperty("id")
    private Integer id;
    @JsonProperty("amount")
    private BigDecimal amount;
    @JsonProperty("description")
    private String description;
    @JsonProperty("statusId")
    private Integer statusId;
    @JsonProperty("statusDesc")
    private String statusDesc;
    @JsonProperty("transactions")
    private List<Transaction> transactions;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getStatusId() {
        return statusId;
    }

    public void setStatusId(Integer statusId) {
        this.statusId = statusId;
    }

    public String getStatusDesc() {
        return statusDesc;
    }

    public void setStatusDesc(String statusDesc) {
        this.statusDesc = statusDesc;
    }

    public List<Transaction> getTransactions() {
        return transactions;
    }

    public void setTransactions(List<Transaction> transactions) {
        this.transactions = transactions;
    }

    @Override
    public String toString() {
        return "ConsultarLinkResponse [" +
                ((id != null) ? "id=" + id + ", " : "") +
                ((amount != null) ? "amount=" + amount + ", " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                ((statusId != null) ? "statusId=" + statusId + ", " : "") +
                ((statusDesc != null) ? "statusDesc='" + statusDesc + "', " : "") +
                ((transactions != null) ? "transactions=" + Arrays.toString(transactions.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ConsultarLinkResponse that = (ConsultarLinkResponse) o;
        return Objects.equals(id, that.id) && Objects.equals(amount, that.amount) && Objects.equals(description, that.description) && Objects.equals(statusId, that.statusId) && Objects.equals(statusDesc, that.statusDesc) && Objects.equals(transactions, that.transactions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, amount, description, statusId, statusDesc, transactions);
    }
}