package ar.com.sdd.agropagoapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CrearLinkResponse implements Serializable {

    @JsonProperty("statusRefId")
    private Integer statusRefId;
    @JsonProperty("id")
    private Integer id;
    @JsonProperty("payerCuit")
    private String payerCuit;
    @JsonProperty("description")
    private String description;
    @JsonProperty("urlRedirect")
    private String urlRedirect;
    @JsonProperty("token")
    private String token;
    @JsonProperty("userId")
    private Integer userId;
    @JsonProperty("customerIdFrom")
    private Integer customerIdFrom;
    @JsonProperty("expirationDate")
    private String expirationDate;
    @JsonProperty("amount")
    private BigDecimal amount;
    @JsonProperty("url")
    private String url;

    public Integer getStatusRefId() {
        return statusRefId;
    }

    public void setStatusRefId(Integer statusRefId) {
        this.statusRefId = statusRefId;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getPayerCuit() {
        return payerCuit;
    }

    public void setPayerCuit(String payerCuit) {
        this.payerCuit = payerCuit;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrlRedirect() {
        return urlRedirect;
    }

    public void setUrlRedirect(String urlRedirect) {
        this.urlRedirect = urlRedirect;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Integer getUserId() {
        return userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public Integer getCustomerIdFrom() {
        return customerIdFrom;
    }

    public void setCustomerIdFrom(Integer customerIdFrom) {
        this.customerIdFrom = customerIdFrom;
    }

    public String getExpirationDate() {
        return expirationDate;
    }

    public void setExpirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String toString() {
        return "CreateLinkResponse [" +
                ((statusRefId != null) ? "statusRefId=" + statusRefId + ", " : "") +
                ((id != null) ? "id=" + id + ", " : "") +
                ((payerCuit != null) ? "payerCuit='" + payerCuit + "', " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                ((urlRedirect != null) ? "urlRedirect='" + urlRedirect + "', " : "") +
                ((token != null) ? "token='" + token + "', " : "") +
                ((userId != null) ? "userId=" + userId + ", " : "") +
                ((customerIdFrom != null) ? "customerIdFrom=" + customerIdFrom + ", " : "") +
                ((expirationDate != null) ? "expirationDate='" + expirationDate + "', " : "") +
                ((amount != null) ? "amount=" + amount + ", " : "") +
                ((url != null) ? "url='" + url + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CrearLinkResponse that = (CrearLinkResponse) o;
        return Objects.equals(statusRefId, that.statusRefId) && Objects.equals(id, that.id) && Objects.equals(payerCuit, that.payerCuit) && Objects.equals(description, that.description) && Objects.equals(urlRedirect, that.urlRedirect) && Objects.equals(token, that.token) && Objects.equals(userId, that.userId) && Objects.equals(customerIdFrom, that.customerIdFrom) && Objects.equals(expirationDate, that.expirationDate) && Objects.equals(amount, that.amount) && Objects.equals(url, that.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(statusRefId, id, payerCuit, description, urlRedirect, token, userId, customerIdFrom, expirationDate, amount, url);
    }
}