package ar.com.sdd.agropagoapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Error implements Serializable {

    @JsonProperty("element")
    private String element;

    @JsonProperty("message")
    private String message;

    public String getElement() {
        return element;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String toString() {
        return "Error [" +
                ((element != null) ? "element='" + element + "', " : "") +
                ((message != null) ? "message='" + message + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Error error = (Error) o;
        return Objects.equals(element, error.element) && Objects.equals(message, error.message);
    }

    @Override
    public int hashCode() {
        return Objects.hash(element, message);
    }
}