package ar.com.sdd.agropagoapi.io;

import ar.com.sdd.agropagoapi.model.PaymenLink;
import ar.com.sdd.agropagoapi.model.Transaction;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ConsultarAllResponse implements Serializable {

    @JsonProperty("recordsTotal")
    private Integer recordsTotal;
    @JsonProperty("recordsFiltered")
    private BigDecimal recordsFiltered;
    @JsonProperty("paymentLinks")
    private List<PaymenLink>     paymentLinks;

    public Integer getRecordsTotal() {
        return recordsTotal;
    }

    public void setRecordsTotal(Integer recordsTotal) {
        this.recordsTotal = recordsTotal;
    }

    public BigDecimal getRecordsFiltered() {
        return recordsFiltered;
    }

    public void setRecordsFiltered(BigDecimal recordsFiltered) {
        this.recordsFiltered = recordsFiltered;
    }

    public List<PaymenLink> getPaymentLinks() {
        return paymentLinks;
    }

    public void setPaymentLinks(List<PaymenLink> paymentLinks) {
        this.paymentLinks = paymentLinks;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ConsultarAllResponse that = (ConsultarAllResponse) o;

        if (!Objects.equals(recordsTotal, that.recordsTotal)) return false;
        if (!Objects.equals(recordsFiltered, that.recordsFiltered)) return false;
        return Objects.equals(paymentLinks, that.paymentLinks);
    }

    @Override
    public int hashCode() {
        int result = recordsTotal != null ? recordsTotal.hashCode() : 0;
        result = 31 * result + (recordsFiltered != null ? recordsFiltered.hashCode() : 0);
        result = 31 * result + (paymentLinks != null ? paymentLinks.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ConsultarAllResponse [" +
                "recordsTotal=" + recordsTotal +
                ", recordsFiltered=" + recordsFiltered +
                ", paymentLinks=" + (paymentLinks == null ? paymentLinks : Arrays.toString(paymentLinks.toArray())) +
                ']';
    }
}