package ar.com.sdd.agropagoapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PaymenLink implements Serializable {
    @JsonProperty("id")
    private Integer id;

    @JsonProperty("description")
    private String description;

    @JsonProperty("amount")
    private String amount;

    @JsonProperty("expirationDate")
    private String expirationDate;

    @JsonProperty("paymentDetail")
    private String paymentDetail;

    @JsonProperty("cuit")
    private String cuit;

    @JsonProperty("statusId")
    private Integer statusId;

    @JsonProperty("statusDesc")
    private String statusDesc;

    @JsonProperty("payerName")
    private String payerName;

    @JsonProperty("url")
    private String urk;

    @JsonProperty("urlRedirect")
    private String urlRedirect;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getExpirationDate() {
        return expirationDate;
    }

    public void setExpirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getPaymentDetail() {
        return paymentDetail;
    }

    public void setPaymentDetail(String paymentDetail) {
        this.paymentDetail = paymentDetail;
    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    public Integer getStatusId() {
        return statusId;
    }

    public void setStatusId(Integer statusId) {
        this.statusId = statusId;
    }

    public String getStatusDesc() {
        return statusDesc;
    }

    public void setStatusDesc(String statusDesc) {
        this.statusDesc = statusDesc;
    }

    public String getPayerName() {
        return payerName;
    }

    public void setPayerName(String payerName) {
        this.payerName = payerName;
    }

    public String getUrk() {
        return urk;
    }

    public void setUrk(String urk) {
        this.urk = urk;
    }

    public String getUrlRedirect() {
        return urlRedirect;
    }

    public void setUrlRedirect(String urlRedirect) {
        this.urlRedirect = urlRedirect;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PaymenLink that = (PaymenLink) o;

        if (!Objects.equals(id, that.id)) return false;
        if (!Objects.equals(description, that.description)) return false;
        if (!Objects.equals(amount, that.amount)) return false;
        if (!Objects.equals(expirationDate, that.expirationDate)) return false;
        if (!Objects.equals(paymentDetail, that.paymentDetail)) return false;
        if (!Objects.equals(cuit, that.cuit)) return false;
        if (!Objects.equals(statusId, that.statusId)) return false;
        if (!Objects.equals(statusDesc, that.statusDesc)) return false;
        if (!Objects.equals(payerName, that.payerName)) return false;
        if (!Objects.equals(urk, that.urk)) return false;
        return Objects.equals(urlRedirect, that.urlRedirect);
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (description != null ? description.hashCode() : 0);
        result = 31 * result + (amount != null ? amount.hashCode() : 0);
        result = 31 * result + (expirationDate != null ? expirationDate.hashCode() : 0);
        result = 31 * result + (paymentDetail != null ? paymentDetail.hashCode() : 0);
        result = 31 * result + (cuit != null ? cuit.hashCode() : 0);
        result = 31 * result + (statusId != null ? statusId.hashCode() : 0);
        result = 31 * result + (statusDesc != null ? statusDesc.hashCode() : 0);
        result = 31 * result + (payerName != null ? payerName.hashCode() : 0);
        result = 31 * result + (urk != null ? urk.hashCode() : 0);
        result = 31 * result + (urlRedirect != null ? urlRedirect.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "PaymenLink [" +
                "id=" + id +
                ", description=" + description +
                ", amount=" + amount +
                ", expirationDate=" + expirationDate +
                ", paymentDetail=" + paymentDetail +
                ", cuit=" + cuit +
                ", statusId=" + statusId +
                ", statusDesc=" + statusDesc +
                ", payerName=" + payerName +
                ", urk=" + urk +
                ", urlRedirect=" + urlRedirect +
                ']';
    }
}