package ar.com.sdd.agrotokenapi.core;

import ar.com.sdd.agrotokenapi.io.CreatePaymentRequest;
import ar.com.sdd.agrotokenapi.io.CreatePaymentResponse;
import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import org.apache.log4j.Logger;

import javax.ws.rs.client.Invocation;

public class AgrotokenApiConnector implements RestSecurityManager {

    private final static Logger log = Logger.getLogger(AgrotokenApiConnector.class);

    private final RestConnector restConnector;
    private final String xApiKey;

    public AgrotokenApiConnector(AgrotokenApiConnectorContext context) {
        this.xApiKey = context.getAgrotokenApiXApiKey();

        log.debug("Creando AgrotokenConnector para url [" + context.getAgrotokenApiBaseUrl() + "] con x-api-key [" + xApiKey + "]");

        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getAgrotokenApiBaseUrl());
        restConnector = new RestConnector(environment, this);
    }

    public CreatePaymentResponse createPaymentRequest(CreatePaymentRequest request) throws RestConnectorException {
        String path = "/payment-requests/";
        log.debug("[createPaymentRequest] Request POST procesar crear pago, request [" + request + "] path [" + path + "]");
        return restConnector.genericPost(request, CreatePaymentResponse.class, path);
    }

    @Override
    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("x-api-key", xApiKey);
        }
        return builder;
    }

    @Override
    public boolean getDisableHTTPSErrors() {
        return false;
    }
}