package ar.com.sdd.agrotokenapi.io;

import ar.com.sdd.agrotokenapi.model.Amount;
import ar.com.sdd.agrotokenapi.model.Payer;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CreatePaymentRequest implements Serializable {

    /**
     * Universally unique identifier (UUID v4) idempotency key. This key is used to ensure exactly-once execution of the request.
     * Example: 21057520-92f1-49e9-a0a8-f89gtt99bf4f
     */
    @JsonProperty("idempotencyKey")
    private String idempotencyKey;

    /**
     * Total amount and currency of the payment
     */
    @JsonProperty("amount")
    private Amount amount;

    /**
     * Possible values: PAYMENT_LINK
     */
    @JsonProperty("paymentType")
    private String paymentType;

    /**
     * Description of the payer
     */
    @JsonProperty("payer")
    private Payer payer;

    /**
     * Description of the product purchased, the reason for payment, etc...
     */
    @JsonProperty("description")
    private String description;

    /**
     * ISO-8601 UTC date/time format. Indicates when the payment request must be invalidated.
     */
    @JsonProperty("expirationDate")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX", timezone = "GMT-03:00")
    private Date expirationDate;

    /**
     * External payment reference, functioning as an identifier of the origin of the transaction.
     */
    @JsonProperty("externalReference")
    private String externalReference;

    /**
     * Notifications URL available to receive notifications of events related to the Payment. Ex: Payment accepted.
     */
    @JsonProperty("notificationUrl")
    private String notificationUrl;

    /**
     * File attached to the payment as receipts or guarantees.
     * Example: "data:application/pdf;name=document%20(2).pdf;base64,JVBERi0xLjQKJeLjz9MKNCAwIG9iago8PC9Db2xvclNwYWNlL0RldmljZVJHQi9TdWJ0eXBlL0ltYWdlL0hlaW......"
     */
    @JsonProperty("attachment")
    private String attachment;

    public String getIdempotencyKey() {
        return idempotencyKey;
    }

    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public Amount getAmount() {
        return amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public String getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    public Payer getPayer() {
        return payer;
    }

    public void setPayer(Payer payer) {
        this.payer = payer;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getExpirationDate() {
        return expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getExternalReference() {
        return externalReference;
    }

    public void setExternalReference(String externalReference) {
        this.externalReference = externalReference;
    }

    public String getNotificationUrl() {
        return notificationUrl;
    }

    public void setNotificationUrl(String notificationUrl) {
        this.notificationUrl = notificationUrl;
    }

    public String getAttachment() {
        return attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    @Override
    public String toString() {
        return "CreatePaymentRequest [" +
                ((idempotencyKey != null) ? "idempotencyKey=" + idempotencyKey + ", " : "") +
                ((amount != null) ? "amount=" + amount + ", " : "") +
                ((paymentType != null) ? "paymentType=" + paymentType + ", " : "") +
                ((payer != null) ? "payer=" + payer + ", " : "") +
                ((description != null) ? "description=" + description + ", " : "") +
                ((expirationDate != null) ? "expirationDate=" + expirationDate + ", " : "") +
                ((externalReference != null) ? "externalReference=" + externalReference + ", " : "") +
                ((notificationUrl != null) ? "notificationUrl=" + notificationUrl + ", " : "") +
                ((attachment != null) ? "attachment=" + attachment + ", " : "") +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CreatePaymentRequest payment = (CreatePaymentRequest) o;
        return Objects.equals(idempotencyKey, payment.idempotencyKey) && Objects.equals(amount, payment.amount) && Objects.equals(paymentType, payment.paymentType) && Objects.equals(payer, payment.payer) && Objects.equals(description, payment.description) && Objects.equals(expirationDate, payment.expirationDate) && Objects.equals(externalReference, payment.externalReference) && Objects.equals(notificationUrl, payment.notificationUrl) && Objects.equals(attachment, payment.attachment);
    }

    @Override
    public int hashCode() {
        return Objects.hash(idempotencyKey, amount, paymentType, payer, description, expirationDate, externalReference, notificationUrl, attachment);
    }
}
