package ar.com.sdd.agrotokenapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Payer implements Serializable {

    /**
     * Accepted values CUIT | CUIL
     */
    @JsonProperty("idType")
    private String idType;

    /**
     * Legal ID of the end user
     * Example: 27107196817
     */
    @JsonProperty("id")
    private String id;

    /**
     * Email of the user
     */
    @JsonProperty("email")
    private String email;

    @JsonProperty("firstName")
    private String firstName;

    @JsonProperty("lastName")
    private String lastName;

    public String getIdType() {
        return idType;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public String toString() {
        return "Payer [" +
                ((idType != null) ? "idType=" + idType + ", " : "") +
                ((id != null) ? "id=" + id + ", " : "") +
                ((email != null) ? "email=" + email + ", " : "") +
                ((firstName != null) ? "firstName=" + firstName + ", " : "") +
                ((lastName != null) ? "lastName=" + lastName + ", " : "") +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Payer payer = (Payer) o;
        return Objects.equals(idType, payer.idType) && Objects.equals(id, payer.id) && Objects.equals(email, payer.email) && Objects.equals(firstName, payer.firstName) && Objects.equals(lastName, payer.lastName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(idType, id, email, firstName, lastName);
    }
}