package ar.com.sdd.agrotokenapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Blockchain implements Serializable {

    @JsonProperty("hash")
    private String hash;

    @JsonProperty("network")
    private String network;

    @JsonProperty("explorerUrl")
    private String explorerUrl;

    public String getHash() {
        return hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getNetwork() {
        return network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public String getExplorerUrl() {
        return explorerUrl;
    }

    public void setExplorerUrl(String explorerUrl) {
        this.explorerUrl = explorerUrl;
    }

    @Override
    public String toString() {
        return "Blockchain{" +
                "hash='" + hash + '\'' +
                ", network='" + network + '\'' +
                ", explorerUrl='" + explorerUrl + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Blockchain that = (Blockchain) o;
        return Objects.equals(hash, that.hash) && Objects.equals(network, that.network) && Objects.equals(explorerUrl, that.explorerUrl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(hash, network, explorerUrl);
    }
}