package ar.com.sdd.agrotokenapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Fee implements Serializable {

    @JsonProperty("feeType")
    private String feeType;

    @JsonProperty("feeAmount")
    private String feeAmount;

    @JsonProperty("feePayer")
    private String feePayer;

    public String getFeeType() {
        return feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public String getFeeAmount() {
        return feeAmount;
    }

    public void setFeeAmount(String feeAmount) {
        this.feeAmount = feeAmount;
    }

    public String getFeePayer() {
        return feePayer;
    }

    public void setFeePayer(String feePayer) {
        this.feePayer = feePayer;
    }

    @Override
    public String toString() {
        return "Fee{" +
                "feeType='" + feeType + '\'' +
                ", feeAmount='" + feeAmount + '\'' +
                ", feePayer='" + feePayer + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Fee fee = (Fee) o;
        return Objects.equals(feeType, fee.feeType) && Objects.equals(feeAmount, fee.feeAmount) && Objects.equals(feePayer, fee.feePayer);
    }

    @Override
    public int hashCode() {
        return Objects.hash(feeType, feeAmount, feePayer);
    }
}