/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.agrotokenapi.core;

import ar.com.sdd.agrotokenapi.core.AgrotokenApiConnectorContext;
import ar.com.sdd.agrotokenapi.io.CreatePaymentRequest;
import ar.com.sdd.agrotokenapi.io.CreatePaymentResponse;
import ar.com.sdd.agrotokenapi.io.GetPaymentResponse;
import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import javax.ws.rs.client.Invocation;
import org.apache.log4j.Logger;

public class AgrotokenApiConnector
implements RestSecurityManager {
    private static final Logger log = Logger.getLogger(AgrotokenApiConnector.class);
    private final RestConnector restConnector;
    private final String xApiKey;

    public AgrotokenApiConnector(AgrotokenApiConnectorContext context) {
        this.xApiKey = context.getAgrotokenApiXApiKey();
        log.debug((Object)("Creando AgrotokenConnector para url [" + context.getAgrotokenApiBaseUrl() + "] con x-api-key [" + this.xApiKey + "]"));
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getAgrotokenApiBaseUrl());
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public CreatePaymentResponse createPaymentRequest(CreatePaymentRequest request) throws RestConnectorException {
        String path = "/payment-requests/";
        log.debug((Object)("[createPaymentRequest] Request POST procesar crear pago, request [" + request + "] path [" + path + "]"));
        return (CreatePaymentResponse)this.restConnector.genericPost((Object)request, CreatePaymentResponse.class, path);
    }

    public GetPaymentResponse getPaymentRequest(String externalReference) throws RestConnectorException {
        String path = "/payment-requests/";
        log.debug((Object)("[getPaymentRequest] Request con externalReference [" + externalReference + "]"));
        GetPaymentResponse response = (GetPaymentResponse)this.restConnector.genericGet(null, GetPaymentResponse.class, path + externalReference);
        log.debug((Object)("[getPaymentRequest] Response con externalReference [" + externalReference + "],  [" + response + "]"));
        return response;
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("x-api-key", (Object)this.xApiKey);
        }
        return builder;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }
}

