package ar.com.sdd.agrotokenapi.io;

import ar.com.sdd.agrotokenapi.model.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CreatePaymentRequest implements Serializable {

    /**
     * Universally unique identifier (UUID v4) idempotency key. This key is used to ensure exactly-once execution of the request.
     * Example: 21057520-92f1-49e9-a0a8-f89gtt99bf4f
     */
    @JsonProperty("idempotencyKey")
    private String idempotencyKey;

    /**
     * Total amount and currency of the payment
     */
    @JsonProperty("amount")
    private Amount amount;

    /**
     * Possible values: PAYMENT_LINK
     */
    @JsonProperty("paymentType")
    private String paymentType;

    /**
     * Description of the payer
     */
    @JsonProperty("payer")
    private Payer payer;

    /**
     * Description of the product purchased, the reason for payment, etc...
     */
    @JsonProperty("description")
    private String description;

    /**
     * ISO-8601 UTC date/time format. Indicates when the payment request must be invalidated.
     */
    @JsonProperty("expirationDate")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timezone = "GMT-03:00")
    private Date expirationDate;

    /**
     * External payment reference, functioning as an identifier of the origin of the transaction.
     */
    @JsonProperty("externalReference")
    private String externalReference;

    /**
     * Notifications URL available to receive notifications of events related to the Payment. Ex: Payment accepted.
     */
    @JsonProperty("notificationUrl")
    private String notificationUrl;

    /**
     * File attached to the payment as receipts or guarantees.
     * Example: "data:application/pdf;name=document%20(2).pdf;base64,JVBERi0xLjQKJeLjz9MKNCAwIG9iago8PC9Db2xvclNwYWNlL0RldmljZVJHQi9TdWJ0eXBlL0ltYWdlL0hlaW......"
     */
    @JsonProperty("attachment")
    private Attachment attachment;

    @JsonProperty("forwarTo")
    private List<ForwardTo> forwardTo;

    public String getIdempotencyKey() {
        return idempotencyKey;
    }

    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public Amount getAmount() {
        return amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public String getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    public Payer getPayer() {
        return payer;
    }

    public void setPayer(Payer payer) {
        this.payer = payer;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getExpirationDate() {
        return expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getExternalReference() {
        return externalReference;
    }

    public void setExternalReference(String externalReference) {
        this.externalReference = externalReference;
    }

    public String getNotificationUrl() {
        return notificationUrl;
    }

    public void setNotificationUrl(String notificationUrl) {
        this.notificationUrl = notificationUrl;
    }

    public Attachment getAttachment() {
        return attachment;
    }

    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }

    public List<ForwardTo> getForwardTo() {
        return forwardTo;
    }

    public void setForwardTo(List<ForwardTo> forwardTo) {
        this.forwardTo = forwardTo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CreatePaymentRequest that = (CreatePaymentRequest) o;

        if (!Objects.equals(idempotencyKey, that.idempotencyKey)) return false;
        if (!Objects.equals(amount, that.amount)) return false;
        if (!Objects.equals(paymentType, that.paymentType)) return false;
        if (!Objects.equals(payer, that.payer)) return false;
        if (!Objects.equals(description, that.description)) return false;
        if (!Objects.equals(expirationDate, that.expirationDate)) return false;
        if (!Objects.equals(externalReference, that.externalReference)) return false;
        if (!Objects.equals(notificationUrl, that.notificationUrl)) return false;
        if (!Objects.equals(attachment, that.attachment)) return false;
        return Objects.equals(forwardTo, that.forwardTo);
    }

    @Override
    public int hashCode() {
        int result = idempotencyKey != null ? idempotencyKey.hashCode() : 0;
        result = 31 * result + (amount != null ? amount.hashCode() : 0);
        result = 31 * result + (paymentType != null ? paymentType.hashCode() : 0);
        result = 31 * result + (payer != null ? payer.hashCode() : 0);
        result = 31 * result + (description != null ? description.hashCode() : 0);
        result = 31 * result + (expirationDate != null ? expirationDate.hashCode() : 0);
        result = 31 * result + (externalReference != null ? externalReference.hashCode() : 0);
        result = 31 * result + (notificationUrl != null ? notificationUrl.hashCode() : 0);
        result = 31 * result + (attachment != null ? attachment.hashCode() : 0);
        result = 31 * result + (forwardTo != null ? forwardTo.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "CreatePaymentRequest [" +
                "idempotencyKey=" + idempotencyKey +
                ", amount=" + amount +
                ", paymentType=" + paymentType +
                ", payer=" + payer +
                ", description=" + description +
                ", expirationDate=" + expirationDate +
                ", externalReference=" + externalReference +
                ", notificationUrl=" + notificationUrl +
                ", attachment=" + attachment +
                ", forwardTo=" + (forwardTo == null ? forwardTo : Arrays.toString(forwardTo.toArray())) +
                ']';
    }
}
