package ar.com.sdd.agrotokenapi.io;

import ar.com.sdd.agrotokenapi.model.Amount;
import ar.com.sdd.agrotokenapi.model.Payer;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CreatePaymentResponse implements Serializable {

    /**
     * Universally unique identifier (UUID v4) idempotency key. This key is used to ensure exactly-once execution of the request.
     * Example: 21057520-92f1-49e9-a0a8-f89gtt99bf4f
     */
    @JsonProperty("idempotencyKey")
    private String idempotencyKey;

    /**
     * Total amount and currency of the payment
     */
    @JsonProperty("amount")
    private Amount amount;

    /**
     * Possible values: PAYMENT_LINK
     */
    @JsonProperty("paymentType")
    private String paymentType;

    /**
     * Description of the payer
     */
    @JsonProperty("payer")
    private Payer payer;

    /**
     * Description of the product purchased, the reason for payment, etc...
     */
    @JsonProperty("description")
    private String description;

    /**
     * ISO-8601 UTC date/time format. Indicates when the payment request must be invalidated.
     * Example: 2023-04-14T23:24:26.416Z
     */
    @JsonProperty("dateCreated")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timezone = "GMT-03:00")
    private Date dateCreated;

    /**
     * External payment reference, functioning as an identifier of the origin of the transaction.
     */
    @JsonProperty("externalReference")
    private String externalReference;

    /**
     * Notifications URL available to receive notifications of events related to the Payment. Ex: Payment accepted.
     */
    @JsonProperty("notificationUrl")
    private String notificationUrl;

    /**
     * Id generado en Agrotoken (externalSystemReference o alguno parecido para nosotros)
     * Example: "a0887b98-792b-4bad-b00e-14293640adeb"
     */
    @JsonProperty("id")
    private String id;

    /**
     * Estado del pago
     * Example: PENDING
     */
    @JsonProperty("status")
    private String status;

    public String getIdempotencyKey() {
        return idempotencyKey;
    }

    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public Amount getAmount() {
        return amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public String getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    public Payer getPayer() {
        return payer;
    }

    public void setPayer(Payer payer) {
        this.payer = payer;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExternalReference() {
        return externalReference;
    }

    public void setExternalReference(String externalReference) {
        this.externalReference = externalReference;
    }

    public String getNotificationUrl() {
        return notificationUrl;
    }

    public void setNotificationUrl(String notificationUrl) {
        this.notificationUrl = notificationUrl;
    }

    public Date getDateCreated() {
        return dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public String toString() {
        return "CreatePaymentResponse [" +
                ((idempotencyKey != null) ? "idempotencyKey=" + idempotencyKey + ", " : "") +
                ((amount != null) ? "amount=" + amount + ", " : "") +
                ((paymentType != null) ? "paymentType=" + paymentType + ", " : "") +
                ((payer != null) ? "payer=" + payer + ", " : "") +
                ((description != null) ? "description=" + description + ", " : "") +
                ((dateCreated != null) ? "dateCreated=" + dateCreated + ", " : "") +
                ((externalReference != null) ? "externalReference=" + externalReference + ", " : "") +
                ((notificationUrl != null) ? "notificationUrl=" + notificationUrl + ", " : "") +
                ((id != null) ? "id=" + id + ", " : "") +
                ((status != null) ? "status=" + status + ", " : "") +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CreatePaymentResponse that = (CreatePaymentResponse) o;
        return Objects.equals(idempotencyKey, that.idempotencyKey) && Objects.equals(amount, that.amount) && Objects.equals(paymentType, that.paymentType) && Objects.equals(payer, that.payer) && Objects.equals(description, that.description) && Objects.equals(dateCreated, that.dateCreated) && Objects.equals(externalReference, that.externalReference) && Objects.equals(notificationUrl, that.notificationUrl) && Objects.equals(id, that.id) && Objects.equals(status, that.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(idempotencyKey, amount, paymentType, payer, description, dateCreated, externalReference, notificationUrl, id, status);
    }
}