package ar.com.sdd.agrotokenapi.io;

import ar.com.sdd.agrotokenapi.model.Amount;
import ar.com.sdd.agrotokenapi.model.Payer;
import ar.com.sdd.agrotokenapi.model.TransactionDetails;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class GetPaymentResponse  implements Serializable {

    /**
     * Id generado en Agrotoken (externalSystemReference o alguno parecido para nosotros)
     * Example: "a0887b98-792b-4bad-b00e-14293640adeb"
     */
    @JsonProperty("id")
    private String id;

    /**
     * Possible values: PAYMENT_LINK
     */
    @JsonProperty("paymentType")
    private String paymentType;

    /**
     * ISO-8601 UTC date/time format. Indicates when the payment request must be invalidated.
     * Example: 2023-04-14T23:24:26.416Z
     */
    @JsonProperty("dateCreated")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timezone = "GMT-03:00")
    private Date dateCreated;

    /**
     * ISO-8601 UTC date/time format. Indicates when the payment request must be invalidated.
     * Example: 2023-04-14T23:24:26.416Z
     */
    @JsonProperty("dateAccepted")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timezone = "GMT-03:00")
    private Date dateAccepted;

    /**
     * Estado del pago
     * Example: PENDING
     */
    @JsonProperty("status")
    private String status;

    /**
     * Total amount and currency of the payment
     */
    @JsonProperty("amount")
    private Amount amount;

    /**
     * Description of the product purchased, the reason for payment, etc...
     */
    @JsonProperty("description")
    private String description;

    /**
     * Description of the payer
     */
    @JsonProperty("payer")
    private Payer payer;

    /**
     * External payment reference, functioning as an identifier of the origin of the transaction.
     */
    @JsonProperty("externalReference")
    private String externalReference;

    /**
     * Notifications URL available to receive notifications of events related to the Payment. Ex: Payment accepted.
     */
    @JsonProperty("notificationUrl")
    private String notificationUrl;

    @JsonProperty("transactionDetails")
    private TransactionDetails transactionDetails;

    /**
     * Universally unique identifier (UUID v4) idempotency key. This key is used to ensure exactly-once execution of the request.
     * Example: 21057520-92f1-49e9-a0a8-f89gtt99bf4f
     */
    @JsonProperty("idempotencyKey")
    private String idempotencyKey;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    public Date getDateCreated() {
        return dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getDateAccepted() {
        return dateAccepted;
    }

    public void setDateAccepted(Date dateAccepted) {
        this.dateAccepted = dateAccepted;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Amount getAmount() {
        return amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Payer getPayer() {
        return payer;
    }

    public void setPayer(Payer payer) {
        this.payer = payer;
    }

    public String getExternalReference() {
        return externalReference;
    }

    public void setExternalReference(String externalReference) {
        this.externalReference = externalReference;
    }

    public String getNotificationUrl() {
        return notificationUrl;
    }

    public void setNotificationUrl(String notificationUrl) {
        this.notificationUrl = notificationUrl;
    }

    public TransactionDetails getTransactionDetails() {
        return transactionDetails;
    }

    public void setTransactionDetails(TransactionDetails transactionDetails) {
        this.transactionDetails = transactionDetails;
    }

    public String getIdempotencyKey() {
        return idempotencyKey;
    }

    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    @Override
    public String toString() {
        return "GetPaymentResponse{" +
                "id='" + id + '\'' +
                ", paymentType='" + paymentType + '\'' +
                ", dateCreated=" + dateCreated +
                ", dateAccepted=" + dateAccepted +
                ", status='" + status + '\'' +
                ", amount=" + amount +
                ", description='" + description + '\'' +
                ", payer=" + payer +
                ", externalReference='" + externalReference + '\'' +
                ", notificationUrl='" + notificationUrl + '\'' +
                ", transactionDetails=" + transactionDetails +
                ", idempotencyKey='" + idempotencyKey + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GetPaymentResponse that = (GetPaymentResponse) o;
        return Objects.equals(id, that.id) && Objects.equals(paymentType, that.paymentType) && Objects.equals(dateCreated, that.dateCreated) && Objects.equals(dateAccepted, that.dateAccepted) && Objects.equals(status, that.status) && Objects.equals(amount, that.amount) && Objects.equals(description, that.description) && Objects.equals(payer, that.payer) && Objects.equals(externalReference, that.externalReference) && Objects.equals(notificationUrl, that.notificationUrl) && Objects.equals(transactionDetails, that.transactionDetails) && Objects.equals(idempotencyKey, that.idempotencyKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, paymentType, dateCreated, dateAccepted, status, amount, description, payer, externalReference, notificationUrl, transactionDetails, idempotencyKey);
    }
}