package ar.com.sdd.agrotokenapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Amount implements Serializable {

    /**
     * Magnitude of the amount, in units of the currency, with a .
     * Example: "10.000"
     */
    @JsonProperty("amount")
    private String amount;

    /**
     * ISO 4217 Currency code. Supported currencies: ARS
     */
    @JsonProperty("currency")
    private String currency;

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Override
    public String toString() {
        return "Amount [" +
                ((amount != null) ? "amount=" + amount + ", " : "") +
                ((currency != null) ? "currency=" + currency + ", " : "") +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Amount amount1 = (Amount) o;
        return Objects.equals(amount, amount1.amount) && Objects.equals(currency, amount1.currency);
    }

    @Override
    public int hashCode() {
        return Objects.hash(amount, currency);
    }
}