/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.agrotokenapi.util;

import ar.com.sdd.agrotokenapi.util.SimpleCache;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class SimpleCacheManager {
    private static SimpleCacheManager instance;
    private Map<String, SimpleCache> caches = new HashMap<String, SimpleCache>();
    private static final Logger log;

    private SimpleCacheManager() {
    }

    public static synchronized SimpleCacheManager getInstance() {
        if (instance == null) {
            instance = new SimpleCacheManager();
        }
        return instance;
    }

    public SimpleCache getCache(String cacheName) {
        return this.getCache(cacheName, SimpleCacheLevel.WEAK);
    }

    public SimpleCache getCache(String cacheName, SimpleCacheLevel cacheLevel) {
        if (this.caches.containsKey(cacheName)) {
            return this.caches.get(cacheName);
        }
        SimpleCache cache = new SimpleCache(cacheName, cacheLevel);
        this.caches.put(cacheName, cache);
        return cache;
    }

    public void invalidate(String cacheName, SimpleCacheLevel minimumLevel) {
        if (!this.caches.containsKey(cacheName)) {
            log.error("No se puede invalidar la cache [" + cacheName + "] porque no existe");
            return;
        }
        SimpleCache cache = this.caches.get(cacheName);
        if (cache.getCacheLevel().isCleareable(minimumLevel)) {
            cache.clear();
        }
    }

    public void invalidateAllCaches(SimpleCacheLevel minimumLevel) {
        Iterator<Map.Entry<String, SimpleCache>> cachesIterator = this.caches.entrySet().iterator();
        while (cachesIterator.hasNext()) {
            Map.Entry<String, SimpleCache> entry = cachesIterator.next();
            this.invalidate(entry.getKey(), minimumLevel);
            SimpleCache cache = entry.getValue();
            if (!cache.getCacheLevel().isCleareable(minimumLevel)) continue;
            cachesIterator.remove();
        }
    }

    public static String buildKey(Object ... objects) {
        StringBuilder key = new StringBuilder();
        boolean first = true;
        for (Object object : objects) {
            if (first) {
                first = false;
            } else {
                key.append("|");
            }
            key.append(object);
        }
        return key.toString();
    }

    static {
        log = LogManager.getLogger(SimpleCacheManager.class);
    }

    public static enum SimpleCacheLevel {
        WEAK(1),
        HARD(10),
        NEVER(Integer.MAX_VALUE);

        private int level;

        private SimpleCacheLevel(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }

        public boolean isCleareable(SimpleCacheLevel minimumLevel) {
            if (minimumLevel.level == SimpleCacheLevel.NEVER.level) {
                return false;
            }
            return this.level <= minimumLevel.level;
        }
    }
}

