package ar.com.sdd.agrotokenapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Price implements Serializable {

    @JsonProperty("name")
    private String name; // The name of the requested currency.

    @JsonProperty("price")
    private String price; // Price of the currency, expressded in referenceCurrency..

    @JsonProperty("referenceCurrency")
    private String referenceCurrency; //  ARS USD BRL The reference currency in which the price of the requested currency is expressed.

    @JsonProperty("inversePrice")
    private String inversePrice; //

    @JsonProperty("priceVariation")
    private String priceVariation; //

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public String getReferenceCurrency() {
        return referenceCurrency;
    }

    public void setReferenceCurrency(String referenceCurrency) {
        this.referenceCurrency = referenceCurrency;
    }

    public String getInversePrice() {
        return inversePrice;
    }

    public void setInversePrice(String inversePrice) {
        this.inversePrice = inversePrice;
    }

    public String getPriceVariation() {
        return priceVariation;
    }

    public void setPriceVariation(String priceVariation) {
        this.priceVariation = priceVariation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Price price1 = (Price) o;

        if (!Objects.equals(name, price1.name)) return false;
        if (!Objects.equals(price, price1.price)) return false;
        if (!Objects.equals(referenceCurrency, price1.referenceCurrency)) return false;
        if (!Objects.equals(inversePrice, price1.inversePrice)) return false;
        return Objects.equals(priceVariation, price1.priceVariation);
    }

    @Override
    public int hashCode() {
        int result = name != null ? name.hashCode() : 0;
        result = 31 * result + (price != null ? price.hashCode() : 0);
        result = 31 * result + (referenceCurrency != null ? referenceCurrency.hashCode() : 0);
        result = 31 * result + (inversePrice != null ? inversePrice.hashCode() : 0);
        result = 31 * result + (priceVariation != null ? priceVariation.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Price [" +
                "name=" + name +
                ", price=" + price +
                ", referenceCurrency=" + referenceCurrency +
                ", inversePrice=" + inversePrice +
                ", priceVariation=" + priceVariation +
                ']';
    }
}