package ar.com.sdd.agrotokenapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class TransactionDetails implements Serializable {

    @JsonProperty("tokenAmount")
    private Amount tokenAmount;

    @JsonProperty("fees")
    private List<Fee> fees;

    @JsonProperty("blockchain")
    private Blockchain blockchain;

    public Amount getTokenAmount() {
        return tokenAmount;
    }

    public void setTokenAmount(Amount tokenAmount) {
        this.tokenAmount = tokenAmount;
    }

    public List<Fee> getFees() {
        return fees;
    }

    public void setFees(List<Fee> fees) {
        this.fees = fees;
    }

    public Blockchain getBlockchain() {
        return blockchain;
    }

    public void setBlockchain(Blockchain blockchain) {
        this.blockchain = blockchain;
    }

    @Override
    public String toString() {
        return "TransactionDetails{" +
                "tokenAmount=" + tokenAmount +
                ", fees=" + fees +
                ", blockchain=" + blockchain +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TransactionDetails that = (TransactionDetails) o;
        return Objects.equals(tokenAmount, that.tokenAmount) && Objects.equals(fees, that.fees) && Objects.equals(blockchain, that.blockchain);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tokenAmount, fees, blockchain);
    }
}