/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.agrotokenapi.core;

import ar.com.sdd.agrotokenapi.core.AgrotokenApiConnectorContext;
import ar.com.sdd.agrotokenapi.io.CreatePaymentRequest;
import ar.com.sdd.agrotokenapi.io.CreatePaymentResponse;
import ar.com.sdd.agrotokenapi.io.GetPaymentResponse;
import ar.com.sdd.agrotokenapi.model.Price;
import ar.com.sdd.agrotokenapi.util.SimpleCache;
import ar.com.sdd.agrotokenapi.util.SimpleCacheManager;
import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.model.TokenOAuth2;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AgrotokenApiConnector
implements RestSecurityManager {
    private static final Logger log = LogManager.getLogger(AgrotokenApiConnector.class);
    private final RestConnector restConnector;
    private final String loginToken;
    private final String authBaseUrl;

    public AgrotokenApiConnector(AgrotokenApiConnectorContext context) {
        this.loginToken = Base64.getEncoder().encodeToString((context.getClientId() + ":" + context.getClientSecret()).getBytes(StandardCharsets.UTF_8));
        this.authBaseUrl = context.getAuthBaseUrl();
        log.debug("Creando AgrotokenConnector para url [" + context.getBaseUrl() + "] con token[" + context.getClientId() + ":" + context.getClientSecret() + "/" + this.loginToken + "]");
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public CreatePaymentResponse createPaymentRequest(CreatePaymentRequest request) throws RestConnectorException {
        String path = "/payment-requests/";
        log.debug("[createPaymentRequest] Request POST procesar crear pago, request [" + request + "] path [/payment-requests/]");
        return (CreatePaymentResponse)this.restConnector.genericPost((Object)request, CreatePaymentResponse.class, "/payment-requests/");
    }

    public GetPaymentResponse getPaymentRequest(String externalReference) throws RestConnectorException {
        String path = "/payment-requests/";
        log.debug("[getPaymentRequest] Request con externalReference [" + externalReference + "]");
        GetPaymentResponse response = (GetPaymentResponse)this.restConnector.genericGet(null, GetPaymentResponse.class, "/payment-requests/" + externalReference);
        log.debug("[getPaymentRequest] Response con externalReference [" + externalReference + "],  [" + response + "]");
        return response;
    }

    public Price getPrice(String symbol) throws RestConnectorException {
        String path = "/prices/{symbol}";
        log.debug("[getPrice] Request con symbol [" + symbol + "]");
        Price response = (Price)this.restConnector.genericGet(null, Price.class, "/prices/{symbol}", "symbol", symbol);
        log.debug("[getPrice] Response con symbol [" + symbol + "],  [" + response + "]");
        return response;
    }

    public List<Price> getPrices() throws RestConnectorException {
        String path = "/prices";
        log.debug("[getPrice] Request");
        List response = (List)this.restConnector.genericGet(null, ArrayList.class, "/prices");
        log.debug("[getPrice] Response [" + response + "]");
        return response;
    }

    public Response getHealth() throws RestConnectorException {
        String path = "/core/health/";
        log.debug("[getHealth] Request");
        Response response = (Response)this.restConnector.genericGet(null, Response.class, "/core/health/");
        log.debug("[getHealth] Response  [" + response + "]");
        return response;
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("Authorization", (Object)("Bearer " + this.getAccessToken()));
        }
        return builder;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    public String getAccessToken() throws RestConnectorException {
        String path = "/oauth2/token";
        SimpleCache tokenCache = SimpleCacheManager.getInstance().getCache(AgrotokenApiConnector.class.getName());
        String accessToken = (String)tokenCache.get("accessToken");
        if (accessToken == null) {
            log.debug("[getAccessToken] Por hacer login y obtener token con [" + this.loginToken + "]");
            RestConnectorEnvironment environment = new RestConnectorEnvironment(this.authBaseUrl);
            RestConnector tokenRestConnector = new RestConnector(environment, new RestSecurityManager(){

                public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
                    builder.header("Authorization", (Object)("Basic " + AgrotokenApiConnector.this.loginToken));
                    return builder;
                }

                public boolean getDisableHTTPSErrors() {
                    return false;
                }
            });
            Form form = new Form();
            form.param("scope", "agtk-api/payment-requests:create agtk-api/payment-requests:read");
            form.param("grant_type", "client_credentials");
            TokenOAuth2 tokenOAuth2Response = (TokenOAuth2)tokenRestConnector.genericPost((Object)form, TokenOAuth2.class, "/oauth2/token", "application/json", "application/x-www-form-urlencoded");
            log.debug("[getAccessToken] Token recuperado [" + tokenOAuth2Response + "]");
            accessToken = tokenOAuth2Response.getAccessToken();
            tokenCache.put("accessToken", accessToken, tokenOAuth2Response.getExpiresIn() - 5);
        }
        return accessToken;
    }
}

