package ar.com.sdd.agrotokenapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ForwardTo implements Serializable {

    @JsonProperty("idType")
    private String idType; //Accepted values CUIT, CNPJ.

    @JsonProperty("id")
    private String id;

    @JsonProperty("amount")
    private String amount;

    @JsonProperty("attachment")
    private String attachment;

    @JsonProperty("description")
    private String description;

    public String getIdType() {
        return idType;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getAttachment() {
        return attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ForwardTo forwardTo = (ForwardTo) o;

        if (!Objects.equals(idType, forwardTo.idType)) return false;
        if (!Objects.equals(id, forwardTo.id)) return false;
        if (!Objects.equals(amount, forwardTo.amount)) return false;
        if (!Objects.equals(attachment, forwardTo.attachment)) return false;
        return Objects.equals(description, forwardTo.description);
    }

    @Override
    public int hashCode() {
        int result = idType != null ? idType.hashCode() : 0;
        result = 31 * result + (id != null ? id.hashCode() : 0);
        result = 31 * result + (amount != null ? amount.hashCode() : 0);
        result = 31 * result + (attachment != null ? attachment.hashCode() : 0);
        result = 31 * result + (description != null ? description.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ForwardTo [" +
                "idType=" + idType +
                ", id=" + id +
                ", amount=" + amount +
                ", attachment=" + attachment +
                ", description=" + description +
                ']';
    }
}