package ar.com.sdd.akanamonsanto.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ConsultaFinanciacionRequest {

    @JsonProperty("NRO_OP")
    private String nroOp;

    @JsonProperty("COD_CLIENTE")
    private String codCliente;

    @JsonProperty("IMPORTE")
    private String importe;

    @JsonProperty("MONEDA")
    private String moneda;

    @JsonProperty("CondicionesSet")
    private Object[] condicionesSet;

    public String getNroOp() {
        return nroOp;
    }

    public void setNroOp(String nroOp) {
        this.nroOp = nroOp;
    }

    public String getCodCliente() {
        return codCliente;
    }

    public void setCodCliente(String codCliente) {
        this.codCliente = codCliente;
    }

    public String getImporte() {
        return importe;
    }

    public void setImporte(String importe) {
        this.importe = importe;
    }

    public String getMoneda() {
        return moneda;
    }

    public void setMoneda(String moneda) {
        this.moneda = moneda;
    }

    public Object[] getCondicionesSet() {
        return condicionesSet;
    }

    public void setCondicionesSet(Object[] condicionesSet) {
        this.condicionesSet = condicionesSet;
    }

    @Override
    public String toString() {
        return "ConsultaFinanciacionRequest [" +
                "nroOp=" + nroOp +
                ", codCliente=" + codCliente +
                ", importe=" + importe +
                ", moneda=" + moneda +
                ", condicionesSet=" + Arrays.toString(condicionesSet) +
                ']';
    }
}
