/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.akanamonsanto.core;

import ar.com.sdd.akanamonsanto.io.TokenOAuth2Response;
import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import java.util.Map;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AkanaMonsantoSecurityManager
implements RestSecurityManager {
    private static final Logger log = Logger.getLogger(AkanaMonsantoSecurityManager.class);
    private String clientId;
    private String clientSecret;
    private String userPass;
    private String tokenUrl;
    private String pathToRequestXCSRFTokenForThisPost;

    public AkanaMonsantoSecurityManager(String clientId, String clientSecret, String userPass, String tokenUrl) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.userPass = userPass;
        this.tokenUrl = tokenUrl;
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        String token = this.recoverToken();
        log.trace((Object)("Token recuperado [" + token + "]"));
        if (!StringUtils.isEmpty((CharSequence)this.pathToRequestXCSRFTokenForThisPost)) {
            log.trace((Object)("Recuperando XCSRF para el path [" + this.pathToRequestXCSRFTokenForThisPost + "]"));
            RestConnectorEnvironment environment = new RestConnectorEnvironment();
            environment.baseUrl = this.pathToRequestXCSRFTokenForThisPost;
            this.pathToRequestXCSRFTokenForThisPost = null;
            RestConnector connector = new RestConnector(environment, null);
            Response postResponseHeaders = connector.buildRequest(environment.baseUrl, null).header("Authorization", (Object)("Bearer " + token + ", Basic " + this.userPass)).header("X-CSRF-Token", (Object)"Fetch").get();
            String headerXCSRFToken = postResponseHeaders.getHeaderString("x-csrf-token");
            builder.header("X-CSRF-Token", (Object)headerXCSRFToken);
            log.trace((Object)("HeaderXCSRFToken [" + headerXCSRFToken + "]"));
            Map cookies = postResponseHeaders.getCookies();
            for (NewCookie cookie : cookies.values()) {
                log.trace((Object)("Cookie [" + cookie + "]"));
                builder.cookie((Cookie)cookie);
            }
            postResponseHeaders.close();
        }
        if (!StringUtils.isEmpty((CharSequence)token)) {
            builder.header("Authorization", (Object)("Bearer " + token + ", Basic " + this.userPass));
        }
        return builder;
    }

    public void requestXCSRFTokenForThisPost(String path) {
        this.pathToRequestXCSRFTokenForThisPost = path;
    }

    public String recoverToken() throws RestConnectorException {
        Form form = new Form();
        form.param("client_id", this.clientId);
        form.param("client_secret", this.clientSecret);
        form.param("grant_type", "client_credentials");
        log.trace((Object)("Por recuperar token con clientId [" + this.clientId + "], clientSecret [" + this.clientSecret + "]"));
        RestConnectorEnvironment environment = new RestConnectorEnvironment();
        environment.baseUrl = this.tokenUrl;
        RestConnector connector = new RestConnector(environment, null);
        TokenOAuth2Response tokenOAuth2Response = (TokenOAuth2Response)connector.genericPost((Object)form, TokenOAuth2Response.class, "", "application/json", "application/x-www-form-urlencoded");
        return tokenOAuth2Response.getAccessToken();
    }
}

