package ar.com.sdd.akanamonsanto.core;

import ar.com.sdd.akanamonsanto.io.ConsultaFinanciacionRequest;
import ar.com.sdd.akanamonsanto.io.ConsultaFinanciacionResponse;
import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import org.apache.log4j.Logger;

public class AkanaMonsantoConnector {

    private static final Logger log = Logger.getLogger(AkanaMonsantoConnector.class);

    private AkanaMonsantoSecurityManager securityManager;
    private RestConnectorEnvironment environment;
    private RestConnector restConnector;

    public AkanaMonsantoConnector(String clientId, String clientSecret, String userPass, String tokenUrl, String baseUrl) {
        log.trace("Inicializando AkanaMonsantoConnector con clientId:[" + clientId + "], clientSecret:[" + clientSecret + "], userPass:[" + userPass + "], tokenUrl:[" + tokenUrl + "], baseUrl:[" + baseUrl + "]");
        securityManager = new AkanaMonsantoSecurityManager(clientId, clientSecret, userPass, tokenUrl);
        environment = new RestConnectorEnvironment();
        environment.baseUrl = baseUrl;
        restConnector = new RestConnector(environment, securityManager);
    }

    public ConsultaFinanciacionResponse consultaFinanciacion(ConsultaFinanciacionRequest request) throws RestConnectorException {
        log.trace("ConsultandaFinanciacion request [" + request + "]");
        securityManager.requestXCSRFTokenForThisPost(environment.baseUrl + "/financiacion");
        ConsultaFinanciacionResponse response = restConnector.genericPost(request, ConsultaFinanciacionResponse.class, "/financiacion");
        log.trace("ConsultandaFinanciacion response [" + response + "]");
        return response;
    }


}
